package org.cardanofoundation.lob.app.support.date;


import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;

public class FlexibleDateParser {

    private FlexibleDateParser() {
        // Private constructor to prevent instantiation
    }


    private static final List<DateTimeFormatter> FORMATTERS = List.of(
            DateTimeFormatter.ofPattern("dd/MM/yyyy"),
            DateTimeFormatter.ofPattern("MM-dd-yyyy"),
            DateTimeFormatter.ofPattern("yyyy-MM-dd"),
            DateTimeFormatter.ofPattern("dd.MM.yyyy")
    );

    public static LocalDate parse(String input) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("Input date string cannot be null or empty");
        }
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                return LocalDate.parse(input, formatter);
            } catch (DateTimeParseException ignored) {
                // Ignore the exception and try the next formatter
            }
        }
        throw new IllegalArgumentException("Unsupported date format: " + input);
    }

}
