/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.spring_web;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import org.cardanofoundation.lob.app.support.security.KeycloakSecurityHelper;
import org.cardanofoundation.lob.app.support.spring_web.BaseRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class OrganisationCheckInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OrganisationCheckInterceptor.class);
    private final KeycloakSecurityHelper keycloakSecurityHelper;
    private final ObjectMapper objectMapper;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.getPrincipal().equals("anonymousUser")) {
            return true;
        }
        if (request.getContentType() != null && request.getContentType().startsWith("multipart/")) {
            return true;
        }
        if (request.getContentType() != null && request.getContentType().contains("application/json")) {
            String body = new String(request.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
            try {
                BaseRequest baseRequest = (BaseRequest)this.objectMapper.readValue(body, BaseRequest.class);
                if (baseRequest.getOrganisationId().isBlank()) {
                    return true;
                }
                boolean isUserInOrganisation = this.keycloakSecurityHelper.canUserAccessOrg(baseRequest.getOrganisationId());
                if (!isUserInOrganisation) {
                    response.setStatus(401);
                    response.getWriter().write("User does not have access to this organisation");
                    return false;
                }
            }
            catch (Exception e) {
                log.debug("Error parsing request body: {}", (Object)e.getMessage());
            }
        }
        return true;
    }

    public OrganisationCheckInterceptor(KeycloakSecurityHelper keycloakSecurityHelper, ObjectMapper objectMapper) {
        this.keycloakSecurityHelper = keycloakSecurityHelper;
        this.objectMapper = objectMapper;
    }
}

