/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.spring_audit.internal;

import jakarta.annotation.PostConstruct;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import org.cardanofoundation.lob.app.support.spring_audit.internal.AuditorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.auditing.DateTimeProvider;
import org.springframework.data.domain.AuditorAware;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;

public class AuditDataProvider
implements AuditorAware<String>,
DateTimeProvider {
    private static final Logger log = LoggerFactory.getLogger(AuditDataProvider.class);
    private final Clock clock;
    private final String SYSTEM_USER = "system";

    @PostConstruct
    public void init() {
        log.info("AuditDataProvider.init");
    }

    public Optional<String> getCurrentAuditor() {
        Object object;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && (object = authentication.getPrincipal()) instanceof Jwt) {
            Jwt jwt = (Jwt)object;
            return Optional.of(jwt.getClaimAsString("name"));
        }
        return Optional.of(AuditorContext.getCurrentUser().orElse("system"));
    }

    public Optional<TemporalAccessor> getNow() {
        return Optional.of(LocalDateTime.now(this.clock));
    }

    public AuditDataProvider(Clock clock) {
        this.clock = clock;
    }
}

