/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.security;

import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Component;

@Component
public class KeycloakSecurityHelper {
    @Value(value="${keycloak.enabled:true}")
    private boolean keycloakEnabled;
    private final String SYSTEM_USER = "system";

    public boolean canUserAccessOrg(String orgId) {
        Object object;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!this.keycloakEnabled) {
            return true;
        }
        if (authentication != null && (object = authentication.getPrincipal()) instanceof Jwt) {
            Jwt jwt = (Jwt)object;
            List organisations = jwt.getClaimAsStringList("organisations");
            return organisations.contains(orgId);
        }
        return false;
    }

    public String getCurrentUser() {
        Object object;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && (object = authentication.getPrincipal()) instanceof Jwt) {
            Jwt jwt = (Jwt)object;
            return jwt.getClaimAsString("name");
        }
        return "system";
    }
}

