/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.spring_web;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import jakarta.annotation.PostConstruct;
import org.cardanofoundation.lob.app.support.spring_web.OrganisationCheckInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SpringWebConfig {
    private static final Logger log = LoggerFactory.getLogger(SpringWebConfig.class);
    @Value(value="${lob.cors.allowed.origins:http://localhost:3000}")
    private String allowedOrigins;
    @Value(value="${keycloak.token-url}")
    private String tokenUrl;
    @Value(value="${keycloak.authorization-url}")
    private String authorizationUrl;
    private final OrganisationCheckInterceptor organisationCheckInterceptor;

    @PostConstruct
    public void init() {
        log.info("CORS configured allowed origins: {}", (Object)this.allowedOrigins);
    }

    @Bean
    public MultipartResolver multipartResolver() {
        return new StandardServletMultipartResolver();
    }

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)SpringWebConfig.this.organisationCheckInterceptor);
            }

            public void addCorsMappings(CorsRegistry registry) {
                registry.addMapping("/api/**").allowedOrigins(SpringWebConfig.this.allowedOrigins.split(",")).allowedMethods(new String[]{"GET", "HEAD", "POST"}).allowedHeaders(new String[]{"*"}).allowCredentials(true);
            }
        };
    }

    @Bean
    public OpenAPI openAPI() {
        return new OpenAPI().components(new Components().addSecuritySchemes("keycloakAuth", new SecurityScheme().name("keycloak").type(SecurityScheme.Type.OAUTH2).bearerFormat("JWT").scheme("bearer").flows(new OAuthFlows().authorizationCode(new OAuthFlow().authorizationUrl(this.authorizationUrl).tokenUrl(this.tokenUrl).scopes(new Scopes().addString("openid", "openid")))))).addSecurityItem(new SecurityRequirement().addList("keycloakAuth")).info(new Info().title("Reeve Service").license(new License().name("Apache License 2.0").url("https://github.com/cardano-foundation/cf-reeve-platform/blob/main/LICENSE")));
    }

    public SpringWebConfig(OrganisationCheckInterceptor organisationCheckInterceptor) {
        this.organisationCheckInterceptor = organisationCheckInterceptor;
    }
}

