/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.spring_web;

import org.cardanofoundation.lob.app.support.security.KeycloakRoleConverter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.web.SecurityFilterChain;

@Configuration(value="securityConfig")
@EnableMethodSecurity
@ConditionalOnProperty(value={"keycloak.enabled"}, havingValue="true")
public class SecurityConfig {
    @Value(value="${keycloak.cert-url}")
    private String certUrl;
    @Value(value="${keycloak.roles.manager}")
    private String managerRole;
    @Value(value="${keycloak.roles.auditor}")
    private String auditorRole;
    @Value(value="${keycloak.roles.accountant}")
    private String accountantRole;
    @Value(value="${keycloak.roles.admin}")
    private String adminRole;
    @Value(value="${security.csp-policy}")
    private String cspPolicy;

    @Bean
    public JwtDecoder jwtDecoder() {
        return NimbusJwtDecoder.withJwkSetUri((String)this.certUrl).build();
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.headers(headers -> headers.contentSecurityPolicy(csp -> csp.policyDirectives(this.cspPolicy))).csrf(csrf -> csrf.disable()).authorizeHttpRequests(authorize -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.anyRequest()).permitAll()).oauth2ResourceServer(oauth2 -> oauth2.jwt(jwt -> jwt.jwtAuthenticationConverter((Converter)this.jwtAuthenticationConverter())));
        return (SecurityFilterChain)http.build();
    }

    private JwtAuthenticationConverter jwtAuthenticationConverter() {
        JwtAuthenticationConverter converter = new JwtAuthenticationConverter();
        converter.setJwtGrantedAuthoritiesConverter((Converter)new KeycloakRoleConverter());
        return converter;
    }

    public String getCertUrl() {
        return this.certUrl;
    }

    public String getManagerRole() {
        return this.managerRole;
    }

    public String getAuditorRole() {
        return this.auditorRole;
    }

    public String getAccountantRole() {
        return this.accountantRole;
    }

    public String getAdminRole() {
        return this.adminRole;
    }

    public String getCspPolicy() {
        return this.cspPolicy;
    }
}

