/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.jakarta_validation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.cardanofoundation.lob.app.support.jakarta_validation.EnumNamePattern;

public class EnumNamePatternValidator
implements ConstraintValidator<EnumNamePattern, Enum<?>> {
    private Pattern pattern;

    public void initialize(EnumNamePattern annotation) {
        try {
            this.pattern = Pattern.compile(annotation.regexp());
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Given regex is invalid", e);
        }
    }

    public boolean isValid(Enum<?> value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        Matcher m = this.pattern.matcher(value.name());
        return m.matches();
    }
}

