/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.database;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SequenceResyncRunner
implements ApplicationRunner {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public void run(ApplicationArguments args) {
        this.resyncSequence("organisation_chart_of_account_type", "id");
        this.resyncSequence("organisation_chart_of_account_sub_type", "id");
    }

    private void resyncSequence(String tableName, String idColumn) {
        String sql = String.format("    SELECT setval(\n        pg_get_serial_sequence('%s', '%s'),\n        COALESCE((SELECT MAX(%s) FROM %s), 0)\n    )\n", tableName, idColumn, idColumn, tableName);
        this.entityManager.createNativeQuery(sql).getSingleResult();
    }
}

