/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.calc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.function.BinaryOperator;

@FunctionalInterface
public interface Summable
extends BinaryOperator<BigDecimal> {
    public BigDecimal sumOf();

    @Override
    default public BigDecimal apply(BigDecimal a, BigDecimal b) {
        return a.add(b);
    }

    public static BigDecimal sum(Summable ... values) {
        return Arrays.stream(values).map(value -> value != null ? value.sumOf() : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}

