/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service.csv;

import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import com.opencsv.exceptions.CsvValidationException;
import io.vavr.control.Either;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.support.security.AntiVirusScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

@Service
public class CsvParser<T> {
    private static final Logger log = LoggerFactory.getLogger(CsvParser.class);
    @Value(value="${lob.csv.delimiter:;}")
    private String delimiter;
    private static final char[] DANGEROUS_PREFIXES = new char[]{'=', '+', '-', '@'};
    private final AntiVirusScanner antiVirusScanner;

    public Either<Problem, List<T>> parseCsv(MultipartFile file, Class<T> type) {
        if (Objects.isNull(file) || file.isEmpty()) {
            String fileIsNullLog = "File is null";
            log.error(fileIsNullLog);
            return Either.left((Object)Problem.builder().withStatus((StatusType)Status.BAD_REQUEST).withTitle("FILE_IS_EMPTY_ERROR").withDetail(fileIsNullLog).build());
        }
        try {
            return this.parseCsv(file.getBytes(), type);
        }
        catch (Exception e) {
            return Either.left((Object)Problem.builder().withStatus((StatusType)Status.BAD_REQUEST).withTitle("CSV_PARSING_ERROR").withDetail(e.getMessage()).build());
        }
    }

    private Either<Problem, Void> checkHeaders(byte[] file, Class<T> type) throws CsvValidationException, IOException {
        CSVReader headerReader = new CSVReaderBuilder((Reader)new InputStreamReader(new ByteArrayInputStream(file))).withSkipLines(0).build();
        String[] csvHeader = headerReader.readNext();
        Set headerSet = csvHeader == null ? Set.of() : Arrays.stream(csvHeader).map(String::trim).collect(Collectors.toSet());
        Set<String> requiredHeaders = this.getRequiredHeaders(type);
        Set missingHeaders = requiredHeaders.stream().filter(req -> headerSet.stream().noneMatch(h -> h.equalsIgnoreCase((String)req))).collect(Collectors.toSet());
        if (!missingHeaders.isEmpty()) {
            return Either.left((Object)Problem.builder().withTitle("CSV_HEADER_ERROR").withStatus((StatusType)Status.BAD_REQUEST).withDetail("Missing required headers: " + String.join((CharSequence)", ", missingHeaders)).build());
        }
        return Either.right(null);
    }

    private <T> Set<String> getRequiredHeaders(Class<T> type) {
        HashSet<String> requiredHeaders = new HashSet<String>();
        for (Field field : type.getDeclaredFields()) {
            CsvBindByName bind = field.getAnnotation(CsvBindByName.class);
            if (bind == null) continue;
            String header = bind.column().isEmpty() ? field.getName() : bind.column();
            requiredHeaders.add(header);
        }
        Optional.ofNullable(type.getSuperclass()).ifPresent(superClass -> requiredHeaders.addAll(this.getRequiredHeaders((Class<T>)superClass)));
        return requiredHeaders;
    }

    public Either<Problem, List<T>> parseCsv(byte[] file, Class<T> type) {
        try {
            if (!this.antiVirusScanner.isFileSafe(file)) {
                return Either.left((Object)Problem.builder().withTitle("MALICIOUS_FILE_DETECTED").withStatus((StatusType)Status.BAD_REQUEST).withDetail("The uploaded file contains malicious content and has been rejected.").build());
            }
            try {
                Either<Problem, Void> headerCheck = this.checkHeaders(file, type);
                if (headerCheck.isLeft()) {
                    return Either.left((Object)((Problem)headerCheck.getLeft()));
                }
            }
            catch (CsvValidationException | IOException e) {
                return Either.left((Object)Problem.builder().withTitle("CSV_HEADER_ERROR").withStatus((StatusType)Status.BAD_REQUEST).withDetail(e.getMessage()).build());
            }
            return Either.right(new CsvToBeanBuilder((Reader)new InputStreamReader(new ByteArrayInputStream(file))).withIgnoreLeadingWhiteSpace(true).withType(type).withSeparator(this.delimiter.charAt(0)).withIgnoreEmptyLine(true).withFieldAsNull(CSVReaderNullFieldIndicator.BOTH).build().parse().stream().map(CsvParser::sanitizeBean).toList());
        }
        catch (Exception e) {
            return Either.left((Object)Problem.builder().withTitle("CSV_PARSING_ERROR").withStatus((StatusType)Status.BAD_REQUEST).withDetail(e.getMessage()).build());
        }
    }

    public static String sanitizeCell(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        char firstChar = value.charAt(0);
        for (char c : DANGEROUS_PREFIXES) {
            if (firstChar != c) continue;
            return "'%s".formatted(value);
        }
        return value;
    }

    public static <T> T sanitizeBean(T bean) {
        for (Field field : bean.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!field.getType().equals(String.class)) continue;
            try {
                String value = (String)field.get(bean);
                field.set(bean, CsvParser.sanitizeCell(value));
            }
            catch (IllegalAccessException ignored) {
                log.debug("Failed to access field {} in bean {}: {}", new Object[]{field.getName(), bean.getClass().getSimpleName(), ignored.getMessage()});
            }
        }
        return bean;
    }

    public CsvParser(AntiVirusScanner antiVirusScanner) {
        this.antiVirusScanner = antiVirusScanner;
    }
}

