/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.resource;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.control.Either;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.request.ChartOfAccountUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.ChartOfAccountSubTypeView;
import org.cardanofoundation.lob.app.organisation.domain.view.ChartOfAccountTypeView;
import org.cardanofoundation.lob.app.organisation.domain.view.ChartOfAccountView;
import org.cardanofoundation.lob.app.organisation.service.ChartOfAccountsService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;

@RestController
@RequestMapping(value={"/api/v1/organisations"})
@Tag(name="Organisation", description="Organisation API")
@CrossOrigin(origins={"http://localhost:3000"})
@ConditionalOnProperty(value={"lob.organisation.enabled"}, havingValue="true", matchIfMissing=true)
public class ChartOfAccountController {
    private final ChartOfAccountsService chartOfAccountsService;

    @Operation(description="Chart of Account tree", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ChartOfAccountTypeView.class)))})})
    @GetMapping(value={"/{orgId}/chart-types"}, produces={"application/json"})
    @Transactional
    public ResponseEntity<List<ChartOfAccountTypeView>> getChartOfAccountTypes(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        return ResponseEntity.ok().body(this.chartOfAccountsService.getAllChartType(orgId).stream().map(chartOfAccountType -> new ChartOfAccountTypeView(chartOfAccountType.getId(), chartOfAccountType.getOrganisationId(), chartOfAccountType.getName(), chartOfAccountType.getSubTypes().stream().map(chartOfAccountSubType -> new ChartOfAccountSubTypeView(chartOfAccountSubType.getId(), chartOfAccountSubType.getOrganisationId(), chartOfAccountSubType.getName(), this.chartOfAccountsService.getBySubTypeId(chartOfAccountSubType.getId()).stream().map(ChartOfAccountView::createSuccess).collect(Collectors.toSet()))).collect(Collectors.toSet()))).toList());
    }

    @Operation(description="Chart of Account list", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ChartOfAccountView.class)))})})
    @GetMapping(value={"/{orgId}/chart-of-accounts"}, produces={"application/json"})
    public ResponseEntity<Set<ChartOfAccountView>> getChartOfAccounts(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        return ResponseEntity.ok().body(this.chartOfAccountsService.getAllChartOfAccount(orgId));
    }

    @Operation(description="Chart Of Account insert", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ChartOfAccountView.class)))})})
    @PostMapping(value={"/{orgId}/chart-of-accounts"}, produces={"application/json"}, consumes={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> insertChartOfAccount(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody ChartOfAccountUpdate chartOfAccountUpdate) {
        ChartOfAccountView chartOfAccountView = this.chartOfAccountsService.insertChartOfAccount(orgId, chartOfAccountUpdate, false);
        if (chartOfAccountView.getError().isPresent()) {
            return ResponseEntity.status((int)chartOfAccountView.getError().get().getStatus().getStatusCode()).body((Object)chartOfAccountView);
        }
        return ResponseEntity.ok((Object)chartOfAccountView);
    }

    @Operation(description="Chart Of Account insert by csv", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ChartOfAccountView.class)))})})
    @PostMapping(value={"/{orgId}/chart-of-accounts"}, consumes={"multipart/form-data"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> insertChartOfAccountByCsv(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @RequestParam(value="file") MultipartFile file) {
        Either<Set<Problem>, Set<ChartOfAccountView>> chartOfAccountE = this.chartOfAccountsService.insertChartOfAccountByCsv(orgId, file);
        if (chartOfAccountE.isEmpty()) {
            return ResponseEntity.status((int)Status.BAD_REQUEST.getStatusCode()).body((Object)((Set)chartOfAccountE.getLeft()));
        }
        return ResponseEntity.ok((Object)((Set)chartOfAccountE.get()));
    }

    @Operation(description="Reference Code update", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ChartOfAccountView.class)))})})
    @PutMapping(value={"/{orgId}/chart-of-accounts"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> updateChartOfAccount(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody ChartOfAccountUpdate chartOfAccountUpdate) {
        ChartOfAccountView referenceCode = this.chartOfAccountsService.updateChartOfAccount(orgId, chartOfAccountUpdate);
        if (referenceCode.getError().isPresent()) {
            return ResponseEntity.status((int)referenceCode.getError().get().getStatus().getStatusCode()).body((Object)referenceCode);
        }
        return ResponseEntity.ok((Object)referenceCode);
    }

    public ChartOfAccountController(ChartOfAccountsService chartOfAccountsService) {
        this.chartOfAccountsService = chartOfAccountsService;
    }
}

