/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.resource;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.control.Either;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Set;
import org.cardanofoundation.lob.app.organisation.domain.request.EventCodeUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.AccountEventView;
import org.cardanofoundation.lob.app.organisation.service.AccountEventService;
import org.cardanofoundation.lob.app.organisation.service.OrganisationService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;

@RestController
@RequestMapping(value={"/api/v1/organisations"})
@Tag(name="Organisation", description="Organisation API")
@CrossOrigin(origins={"http://localhost:3000"})
@ConditionalOnProperty(value={"lob.organisation.enabled"}, havingValue="true", matchIfMissing=true)
public class AccountEventController {
    private final AccountEventService eventCodeService;
    private final OrganisationService organisationService;

    @Operation(description="Reference Codes", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AccountEventView.class)))})})
    @GetMapping(value={"/{orgId}/event-codes"}, produces={"application/json"})
    public ResponseEntity<List<AccountEventView>> getReferenceCodes(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        return ResponseEntity.ok().body(this.eventCodeService.getAllAccountEvent(orgId));
    }

    @Operation(description="Reference Code insert", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=AccountEventView.class))})})
    @PostMapping(value={"/{orgId}/event-codes"}, consumes={"application/json"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> insertReferenceCode(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody EventCodeUpdate eventCodeUpdate) {
        AccountEventView eventCode = this.eventCodeService.insertAccountEvent(orgId, eventCodeUpdate, false);
        if (eventCode.getError().isPresent()) {
            return ResponseEntity.status((int)eventCode.getError().get().getStatus().getStatusCode()).body((Object)eventCode);
        }
        return ResponseEntity.ok((Object)eventCode);
    }

    @Operation(description="Reference Code insert", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=AccountEventView.class))})})
    @PostMapping(value={"/{orgId}/event-codes"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> insertReferenceCodeByCsv(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @RequestParam(value="file") MultipartFile file) {
        Either<Set<Problem>, Set<AccountEventView>> eventCodeE = this.eventCodeService.insertAccountEventByCsv(orgId, file);
        if (eventCodeE.isLeft()) {
            Set errors = (Set)eventCodeE.getLeft();
            return ResponseEntity.status((int)Status.BAD_REQUEST.getStatusCode()).body((Object)errors);
        }
        return ResponseEntity.ok((Object)((Set)eventCodeE.get()));
    }

    @Operation(description="Reference Code update", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=AccountEventView.class))})})
    @PutMapping(value={"/{orgId}/event-codes"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> updateReferenceCode(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody EventCodeUpdate eventCodeUpdate) {
        AccountEventView eventCode = this.eventCodeService.updateAccountEvent(orgId, eventCodeUpdate);
        if (eventCode.getError().isPresent()) {
            return ResponseEntity.status((int)eventCode.getError().get().getStatus().getStatusCode()).body((Object)eventCode);
        }
        return ResponseEntity.ok((Object)eventCode);
    }

    public AccountEventController(AccountEventService eventCodeService, OrganisationService organisationService) {
        this.eventCodeService = eventCodeService;
        this.organisationService = organisationService;
    }
}

