/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.view;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import org.cardanofoundation.lob.app.organisation.domain.core.OrganisationViolation;

public class ValidationView {
    @Schema(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94")
    private String organisationId;
    private List<OrganisationViolation> violations;
    private boolean isValid;

    public static ValidationViewBuilder builder() {
        return new ValidationViewBuilder();
    }

    public String getOrganisationId() {
        return this.organisationId;
    }

    public List<OrganisationViolation> getViolations() {
        return this.violations;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public ValidationView(String organisationId, List<OrganisationViolation> violations, boolean isValid) {
        this.organisationId = organisationId;
        this.violations = violations;
        this.isValid = isValid;
    }

    public static class ValidationViewBuilder {
        private String organisationId;
        private List<OrganisationViolation> violations;
        private boolean isValid;

        ValidationViewBuilder() {
        }

        public ValidationViewBuilder organisationId(String organisationId) {
            this.organisationId = organisationId;
            return this;
        }

        public ValidationViewBuilder violations(List<OrganisationViolation> violations) {
            this.violations = violations;
            return this;
        }

        public ValidationViewBuilder isValid(boolean isValid) {
            this.isValid = isValid;
            return this;
        }

        public ValidationView build() {
            return new ValidationView(this.organisationId, this.violations, this.isValid);
        }

        public String toString() {
            return "ValidationView.ValidationViewBuilder(organisationId=" + this.organisationId + ", violations=" + String.valueOf(this.violations) + ", isValid=" + this.isValid + ")";
        }
    }
}

