/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.view;

import java.util.Objects;
import java.util.Optional;
import org.cardanofoundation.lob.app.organisation.domain.entity.ReferenceCode;
import org.cardanofoundation.lob.app.organisation.domain.request.ReferenceCodeUpdate;
import org.zalando.problem.Problem;

public class ReferenceCodeView {
    String referenceCode;
    String description;
    ReferenceCodeView parent;
    String parentReferenceCode;
    boolean isActive;
    private Optional<Problem> error;

    public static ReferenceCodeView fromEntity(ReferenceCode referenceCode) {
        ReferenceCodeViewBuilder builder = ReferenceCodeView.builder().referenceCode(Objects.requireNonNull(referenceCode.getId()).getReferenceCode()).description(referenceCode.getName()).isActive(referenceCode.isActive()).error(Optional.empty());
        if (referenceCode.getParent().isPresent()) {
            builder.parent(ReferenceCodeView.fromEntity(referenceCode.getParent().get()));
        }
        return builder.build();
    }

    public static ReferenceCodeView createFail(Problem error, ReferenceCodeUpdate referenceCodeUpdate) {
        return ReferenceCodeView.builder().referenceCode(referenceCodeUpdate.getReferenceCode()).description(referenceCodeUpdate.getName()).parentReferenceCode(referenceCodeUpdate.getParentReferenceCode()).isActive(referenceCodeUpdate.isActive()).error(Optional.of(error)).build();
    }

    public static ReferenceCodeViewBuilder builder() {
        return new ReferenceCodeViewBuilder();
    }

    public String getReferenceCode() {
        return this.referenceCode;
    }

    public String getDescription() {
        return this.description;
    }

    public ReferenceCodeView getParent() {
        return this.parent;
    }

    public String getParentReferenceCode() {
        return this.parentReferenceCode;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Optional<Problem> getError() {
        return this.error;
    }

    public ReferenceCodeView(String referenceCode, String description, ReferenceCodeView parent, String parentReferenceCode, boolean isActive, Optional<Problem> error) {
        this.referenceCode = referenceCode;
        this.description = description;
        this.parent = parent;
        this.parentReferenceCode = parentReferenceCode;
        this.isActive = isActive;
        this.error = error;
    }

    public static class ReferenceCodeViewBuilder {
        private String referenceCode;
        private String description;
        private ReferenceCodeView parent;
        private String parentReferenceCode;
        private boolean isActive;
        private Optional<Problem> error;

        ReferenceCodeViewBuilder() {
        }

        public ReferenceCodeViewBuilder referenceCode(String referenceCode) {
            this.referenceCode = referenceCode;
            return this;
        }

        public ReferenceCodeViewBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ReferenceCodeViewBuilder parent(ReferenceCodeView parent) {
            this.parent = parent;
            return this;
        }

        public ReferenceCodeViewBuilder parentReferenceCode(String parentReferenceCode) {
            this.parentReferenceCode = parentReferenceCode;
            return this;
        }

        public ReferenceCodeViewBuilder isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public ReferenceCodeViewBuilder error(Optional<Problem> error) {
            this.error = error;
            return this;
        }

        public ReferenceCodeView build() {
            return new ReferenceCodeView(this.referenceCode, this.description, this.parent, this.parentReferenceCode, this.isActive, this.error);
        }

        public String toString() {
            return "ReferenceCodeView.ReferenceCodeViewBuilder(referenceCode=" + this.referenceCode + ", description=" + this.description + ", parent=" + String.valueOf(this.parent) + ", parentReferenceCode=" + this.parentReferenceCode + ", isActive=" + this.isActive + ", error=" + String.valueOf(this.error) + ")";
        }
    }
}

