/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.view;

import java.util.Optional;
import org.cardanofoundation.lob.app.organisation.domain.csv.ProjectUpdate;
import org.cardanofoundation.lob.app.organisation.domain.entity.Project;
import org.zalando.problem.Problem;

public class ProjectView {
    private String customerCode;
    private String name;
    private ProjectView parent;
    private String parentCustomerCode;
    private Optional<Problem> error;

    public static ProjectView fromEntity(Project project) {
        ProjectViewBuilder builder = ProjectView.builder().customerCode(project.getId() == null ? null : project.getId().getCustomerCode()).name(project.getName()).error(Optional.empty());
        if (project.getParent().isPresent()) {
            builder.parent(ProjectView.fromEntity(project.getParent().get()));
        }
        return builder.build();
    }

    public static ProjectView createFail(ProjectUpdate projectUpdate, Problem error) {
        return ProjectView.builder().customerCode(projectUpdate.getCustomerCode()).name(projectUpdate.getName()).parentCustomerCode(projectUpdate.getParentCustomerCode()).error(Optional.of(error)).build();
    }

    public static ProjectViewBuilder builder() {
        return new ProjectViewBuilder();
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getName() {
        return this.name;
    }

    public ProjectView getParent() {
        return this.parent;
    }

    public String getParentCustomerCode() {
        return this.parentCustomerCode;
    }

    public Optional<Problem> getError() {
        return this.error;
    }

    public ProjectView(String customerCode, String name, ProjectView parent, String parentCustomerCode, Optional<Problem> error) {
        this.customerCode = customerCode;
        this.name = name;
        this.parent = parent;
        this.parentCustomerCode = parentCustomerCode;
        this.error = error;
    }

    public static class ProjectViewBuilder {
        private String customerCode;
        private String name;
        private ProjectView parent;
        private String parentCustomerCode;
        private Optional<Problem> error;

        ProjectViewBuilder() {
        }

        public ProjectViewBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public ProjectViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProjectViewBuilder parent(ProjectView parent) {
            this.parent = parent;
            return this;
        }

        public ProjectViewBuilder parentCustomerCode(String parentCustomerCode) {
            this.parentCustomerCode = parentCustomerCode;
            return this;
        }

        public ProjectViewBuilder error(Optional<Problem> error) {
            this.error = error;
            return this;
        }

        public ProjectView build() {
            return new ProjectView(this.customerCode, this.name, this.parent, this.parentCustomerCode, this.error);
        }

        public String toString() {
            return "ProjectView.ProjectViewBuilder(customerCode=" + this.customerCode + ", name=" + this.name + ", parent=" + String.valueOf(this.parent) + ", parentCustomerCode=" + this.parentCustomerCode + ", error=" + String.valueOf(this.error) + ")";
        }
    }
}

