/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.view;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDate;
import java.util.Set;
import org.cardanofoundation.lob.app.organisation.domain.view.CostCenterView;
import org.cardanofoundation.lob.app.organisation.domain.view.ProjectView;

public class OrganisationView {
    @Schema(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94")
    String id;
    @Schema(example="Cardano Foundation")
    String name;
    @Schema(example="CHE-184477354")
    String taxIdNumber;
    @Schema(example="CHE")
    String currencyId;
    @Schema(example="CHE")
    String reportCurrencyId;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    @Schema(example="2021-02-05")
    LocalDate accountPeriodFrom;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    @Schema(example="2024-02-05")
    LocalDate accountPeriodTo;
    @Schema(example="lob@cardanofoundation.org")
    private String adminEmail;
    @Schema(example="0035863286566")
    private String phoneNumber;
    @Schema(example="Street name and number")
    private String address;
    @Schema(example="Ballyhealy")
    private String city;
    @Schema(example="Y35 C6KC")
    private String postCode;
    @Schema(example="Co. Wexford")
    private String province;
    @Schema(example="IE")
    private String countryCode;
    private Set<CostCenterView> costCenters;
    private Set<ProjectView> projects;
    private Set<String> organisationCurrencies;
    private String websiteUrl;
    @Schema(example="data:image/jpeg;base64,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")
    private String logo;

    public static OrganisationViewBuilder builder() {
        return new OrganisationViewBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTaxIdNumber() {
        return this.taxIdNumber;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public String getReportCurrencyId() {
        return this.reportCurrencyId;
    }

    public LocalDate getAccountPeriodFrom() {
        return this.accountPeriodFrom;
    }

    public LocalDate getAccountPeriodTo() {
        return this.accountPeriodTo;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCity() {
        return this.city;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public String getProvince() {
        return this.province;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Set<CostCenterView> getCostCenters() {
        return this.costCenters;
    }

    public Set<ProjectView> getProjects() {
        return this.projects;
    }

    public Set<String> getOrganisationCurrencies() {
        return this.organisationCurrencies;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public String getLogo() {
        return this.logo;
    }

    public OrganisationView(String id, String name, String taxIdNumber, String currencyId, String reportCurrencyId, LocalDate accountPeriodFrom, LocalDate accountPeriodTo, String adminEmail, String phoneNumber, String address, String city, String postCode, String province, String countryCode, Set<CostCenterView> costCenters, Set<ProjectView> projects, Set<String> organisationCurrencies, String websiteUrl, String logo) {
        this.id = id;
        this.name = name;
        this.taxIdNumber = taxIdNumber;
        this.currencyId = currencyId;
        this.reportCurrencyId = reportCurrencyId;
        this.accountPeriodFrom = accountPeriodFrom;
        this.accountPeriodTo = accountPeriodTo;
        this.adminEmail = adminEmail;
        this.phoneNumber = phoneNumber;
        this.address = address;
        this.city = city;
        this.postCode = postCode;
        this.province = province;
        this.countryCode = countryCode;
        this.costCenters = costCenters;
        this.projects = projects;
        this.organisationCurrencies = organisationCurrencies;
        this.websiteUrl = websiteUrl;
        this.logo = logo;
    }

    public static class OrganisationViewBuilder {
        private String id;
        private String name;
        private String taxIdNumber;
        private String currencyId;
        private String reportCurrencyId;
        private LocalDate accountPeriodFrom;
        private LocalDate accountPeriodTo;
        private String adminEmail;
        private String phoneNumber;
        private String address;
        private String city;
        private String postCode;
        private String province;
        private String countryCode;
        private Set<CostCenterView> costCenters;
        private Set<ProjectView> projects;
        private Set<String> organisationCurrencies;
        private String websiteUrl;
        private String logo;

        OrganisationViewBuilder() {
        }

        public OrganisationViewBuilder id(String id) {
            this.id = id;
            return this;
        }

        public OrganisationViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OrganisationViewBuilder taxIdNumber(String taxIdNumber) {
            this.taxIdNumber = taxIdNumber;
            return this;
        }

        public OrganisationViewBuilder currencyId(String currencyId) {
            this.currencyId = currencyId;
            return this;
        }

        public OrganisationViewBuilder reportCurrencyId(String reportCurrencyId) {
            this.reportCurrencyId = reportCurrencyId;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        public OrganisationViewBuilder accountPeriodFrom(LocalDate accountPeriodFrom) {
            this.accountPeriodFrom = accountPeriodFrom;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        public OrganisationViewBuilder accountPeriodTo(LocalDate accountPeriodTo) {
            this.accountPeriodTo = accountPeriodTo;
            return this;
        }

        public OrganisationViewBuilder adminEmail(String adminEmail) {
            this.adminEmail = adminEmail;
            return this;
        }

        public OrganisationViewBuilder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public OrganisationViewBuilder address(String address) {
            this.address = address;
            return this;
        }

        public OrganisationViewBuilder city(String city) {
            this.city = city;
            return this;
        }

        public OrganisationViewBuilder postCode(String postCode) {
            this.postCode = postCode;
            return this;
        }

        public OrganisationViewBuilder province(String province) {
            this.province = province;
            return this;
        }

        public OrganisationViewBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public OrganisationViewBuilder costCenters(Set<CostCenterView> costCenters) {
            this.costCenters = costCenters;
            return this;
        }

        public OrganisationViewBuilder projects(Set<ProjectView> projects) {
            this.projects = projects;
            return this;
        }

        public OrganisationViewBuilder organisationCurrencies(Set<String> organisationCurrencies) {
            this.organisationCurrencies = organisationCurrencies;
            return this;
        }

        public OrganisationViewBuilder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public OrganisationViewBuilder logo(String logo) {
            this.logo = logo;
            return this;
        }

        public OrganisationView build() {
            return new OrganisationView(this.id, this.name, this.taxIdNumber, this.currencyId, this.reportCurrencyId, this.accountPeriodFrom, this.accountPeriodTo, this.adminEmail, this.phoneNumber, this.address, this.city, this.postCode, this.province, this.countryCode, this.costCenters, this.projects, this.organisationCurrencies, this.websiteUrl, this.logo);
        }

        public String toString() {
            return "OrganisationView.OrganisationViewBuilder(id=" + this.id + ", name=" + this.name + ", taxIdNumber=" + this.taxIdNumber + ", currencyId=" + this.currencyId + ", reportCurrencyId=" + this.reportCurrencyId + ", accountPeriodFrom=" + String.valueOf(this.accountPeriodFrom) + ", accountPeriodTo=" + String.valueOf(this.accountPeriodTo) + ", adminEmail=" + this.adminEmail + ", phoneNumber=" + this.phoneNumber + ", address=" + this.address + ", city=" + this.city + ", postCode=" + this.postCode + ", province=" + this.province + ", countryCode=" + this.countryCode + ", costCenters=" + String.valueOf(this.costCenters) + ", projects=" + String.valueOf(this.projects) + ", organisationCurrencies=" + String.valueOf(this.organisationCurrencies) + ", websiteUrl=" + this.websiteUrl + ", logo=" + this.logo + ")";
        }
    }
}

