/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.view;

import java.util.Optional;
import org.cardanofoundation.lob.app.organisation.domain.entity.AccountEvent;
import org.cardanofoundation.lob.app.organisation.domain.request.EventCodeUpdate;
import org.zalando.problem.Problem;

public class AccountEventView {
    private String organisationId;
    private String debitReferenceCode;
    private String creditReferenceCode;
    private String customerCode;
    private String description;
    private Boolean active;
    private Optional<Problem> error;

    public static AccountEventView convertFromEntity(AccountEvent eventCode) {
        return AccountEventView.builder().debitReferenceCode(eventCode.getId().getDebitReferenceCode()).creditReferenceCode(eventCode.getId().getCreditReferenceCode()).customerCode(eventCode.getCustomerCode()).organisationId(eventCode.getId().getOrganisationId()).description(eventCode.getName()).active(eventCode.getActive()).error(Optional.empty()).build();
    }

    public static AccountEventView createFail(Problem error, EventCodeUpdate eventCodeUpdate) {
        return AccountEventView.builder().debitReferenceCode(eventCodeUpdate.getDebitReferenceCode()).creditReferenceCode(eventCodeUpdate.getCreditReferenceCode()).description(eventCodeUpdate.getName()).error(Optional.of(error)).build();
    }

    public static AccountEventViewBuilder builder() {
        return new AccountEventViewBuilder();
    }

    public String getOrganisationId() {
        return this.organisationId;
    }

    public String getDebitReferenceCode() {
        return this.debitReferenceCode;
    }

    public String getCreditReferenceCode() {
        return this.creditReferenceCode;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Optional<Problem> getError() {
        return this.error;
    }

    public AccountEventView(String organisationId, String debitReferenceCode, String creditReferenceCode, String customerCode, String description, Boolean active, Optional<Problem> error) {
        this.organisationId = organisationId;
        this.debitReferenceCode = debitReferenceCode;
        this.creditReferenceCode = creditReferenceCode;
        this.customerCode = customerCode;
        this.description = description;
        this.active = active;
        this.error = error;
    }

    public static class AccountEventViewBuilder {
        private String organisationId;
        private String debitReferenceCode;
        private String creditReferenceCode;
        private String customerCode;
        private String description;
        private Boolean active;
        private Optional<Problem> error;

        AccountEventViewBuilder() {
        }

        public AccountEventViewBuilder organisationId(String organisationId) {
            this.organisationId = organisationId;
            return this;
        }

        public AccountEventViewBuilder debitReferenceCode(String debitReferenceCode) {
            this.debitReferenceCode = debitReferenceCode;
            return this;
        }

        public AccountEventViewBuilder creditReferenceCode(String creditReferenceCode) {
            this.creditReferenceCode = creditReferenceCode;
            return this;
        }

        public AccountEventViewBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public AccountEventViewBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AccountEventViewBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public AccountEventViewBuilder error(Optional<Problem> error) {
            this.error = error;
            return this;
        }

        public AccountEventView build() {
            return new AccountEventView(this.organisationId, this.debitReferenceCode, this.creditReferenceCode, this.customerCode, this.description, this.active, this.error);
        }

        public String toString() {
            return "AccountEventView.AccountEventViewBuilder(organisationId=" + this.organisationId + ", debitReferenceCode=" + this.debitReferenceCode + ", creditReferenceCode=" + this.creditReferenceCode + ", customerCode=" + this.customerCode + ", description=" + this.description + ", active=" + this.active + ", error=" + String.valueOf(this.error) + ")";
        }
    }
}

