/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Optional;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_project")
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class Project
extends CommonEntity
implements Persistable<Id> {
    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="organisationId", column=@Column(name="organisation_id")), @AttributeOverride(name="customerCode", column=@Column(name="customer_code"))})
    private Id id;
    @Column(name="name", nullable=false)
    private String name;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="organisation_id", referencedColumnName="organisation_id", insertable=false, updatable=false), @JoinColumn(name="parent_customer_code", referencedColumnName="customer_code", insertable=false, updatable=false)})
    @NotAudited
    private Project parent;
    @Column(name="parent_customer_code")
    private String parentCustomerCode;

    public Optional<Project> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public static ProjectBuilder builder() {
        return new ProjectBuilder();
    }

    public Project(Id id, String name, Project parent, String parentCustomerCode) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.parentCustomerCode = parentCustomerCode;
    }

    public Project() {
    }

    public Id getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getParentCustomerCode() {
        return this.parentCustomerCode;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(Project parent) {
        this.parent = parent;
    }

    public void setParentCustomerCode(String parentCustomerCode) {
        this.parentCustomerCode = parentCustomerCode;
    }

    public static class ProjectBuilder {
        private Id id;
        private String name;
        private Project parent;
        private String parentCustomerCode;

        ProjectBuilder() {
        }

        public ProjectBuilder id(Id id) {
            this.id = id;
            return this;
        }

        public ProjectBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ProjectBuilder parent(Project parent) {
            this.parent = parent;
            return this;
        }

        public ProjectBuilder parentCustomerCode(String parentCustomerCode) {
            this.parentCustomerCode = parentCustomerCode;
            return this;
        }

        public Project build() {
            return new Project(this.id, this.name, this.parent, this.parentCustomerCode);
        }

        public String toString() {
            return "Project.ProjectBuilder(id=" + String.valueOf(this.id) + ", name=" + this.name + ", parent=" + String.valueOf((Object)this.parent) + ", parentCustomerCode=" + this.parentCustomerCode + ")";
        }
    }

    @Embeddable
    public static class Id {
        private String organisationId;
        private String customerCode;

        public Id(String organisationId, String customerCode) {
            this.organisationId = organisationId;
            this.customerCode = customerCode;
        }

        public Id() {
        }

        public String getOrganisationId() {
            return this.organisationId;
        }

        public String getCustomerCode() {
            return this.customerCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$organisationId = this.getOrganisationId();
            String other$organisationId = other.getOrganisationId();
            if (this$organisationId == null ? other$organisationId != null : !this$organisationId.equals(other$organisationId)) {
                return false;
            }
            String this$customerCode = this.getCustomerCode();
            String other$customerCode = other.getCustomerCode();
            return !(this$customerCode == null ? other$customerCode != null : !this$customerCode.equals(other$customerCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Id;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $organisationId = this.getOrganisationId();
            result = result * 59 + ($organisationId == null ? 43 : $organisationId.hashCode());
            String $customerCode = this.getCustomerCode();
            result = result * 59 + ($customerCode == null ? 43 : $customerCode.hashCode());
            return result;
        }
    }
}

