/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import javax.annotation.Nullable;
import org.cardanofoundation.lob.app.organisation.domain.entity.ChartOfAccountSubType;
import org.cardanofoundation.lob.app.organisation.domain.entity.OpeningBalance;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.envers.Audited;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_chart_of_account")
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class ChartOfAccount
extends CommonEntity
implements Persistable<Id> {
    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="organisationId", column=@Column(name="organisation_id")), @AttributeOverride(name="customerCode", column=@Column(name="customer_code"))})
    private Id id;
    @Column(name="event_ref_code", nullable=false)
    private String eventRefCode;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="currency_id", nullable=false)
    private String currencyId;
    @Column(name="counter_party", nullable=false)
    private String counterParty;
    @Column(name="parent_customer_code")
    private String parentCustomerCode;
    @Column(name="active", nullable=false)
    private Boolean active;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="subType", referencedColumnName="id")
    private ChartOfAccountSubType subType;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="balanceFCY", column=@Column(name="opening_balance_balance_fcy")), @AttributeOverride(name="balanceLCY", column=@Column(name="opening_balance_balance_lcy")), @AttributeOverride(name="originalCurrencyIdFCY", column=@Column(name="opening_balance_original_currency_id_fcy")), @AttributeOverride(name="originalCurrencyIdLCY", column=@Column(name="opening_balance_original_currency_id_lcy")), @AttributeOverride(name="balanceType", column=@Column(name="opening_balance_balance_type")), @AttributeOverride(name="date", column=@Column(name="opening_balance_date"))})
    @Nullable
    private OpeningBalance openingBalance;

    private static Boolean $default$active() {
        return true;
    }

    public static ChartOfAccountBuilder builder() {
        return new ChartOfAccountBuilder();
    }

    public ChartOfAccount(Id id, String eventRefCode, String name, String currencyId, String counterParty, String parentCustomerCode, Boolean active, ChartOfAccountSubType subType, @Nullable OpeningBalance openingBalance) {
        this.id = id;
        this.eventRefCode = eventRefCode;
        this.name = name;
        this.currencyId = currencyId;
        this.counterParty = counterParty;
        this.parentCustomerCode = parentCustomerCode;
        this.active = active;
        this.subType = subType;
        this.openingBalance = openingBalance;
    }

    public ChartOfAccount() {
        this.active = ChartOfAccount.$default$active();
    }

    public Id getId() {
        return this.id;
    }

    public String getEventRefCode() {
        return this.eventRefCode;
    }

    public String getName() {
        return this.name;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public String getCounterParty() {
        return this.counterParty;
    }

    public String getParentCustomerCode() {
        return this.parentCustomerCode;
    }

    public Boolean getActive() {
        return this.active;
    }

    public ChartOfAccountSubType getSubType() {
        return this.subType;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public void setEventRefCode(String eventRefCode) {
        this.eventRefCode = eventRefCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public void setCounterParty(String counterParty) {
        this.counterParty = counterParty;
    }

    public void setParentCustomerCode(String parentCustomerCode) {
        this.parentCustomerCode = parentCustomerCode;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setSubType(ChartOfAccountSubType subType) {
        this.subType = subType;
    }

    @Nullable
    public OpeningBalance getOpeningBalance() {
        return this.openingBalance;
    }

    public void setOpeningBalance(@Nullable OpeningBalance openingBalance) {
        this.openingBalance = openingBalance;
    }

    public static class ChartOfAccountBuilder {
        private Id id;
        private String eventRefCode;
        private String name;
        private String currencyId;
        private String counterParty;
        private String parentCustomerCode;
        private boolean active$set;
        private Boolean active$value;
        private ChartOfAccountSubType subType;
        private OpeningBalance openingBalance;

        ChartOfAccountBuilder() {
        }

        public ChartOfAccountBuilder id(Id id) {
            this.id = id;
            return this;
        }

        public ChartOfAccountBuilder eventRefCode(String eventRefCode) {
            this.eventRefCode = eventRefCode;
            return this;
        }

        public ChartOfAccountBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChartOfAccountBuilder currencyId(String currencyId) {
            this.currencyId = currencyId;
            return this;
        }

        public ChartOfAccountBuilder counterParty(String counterParty) {
            this.counterParty = counterParty;
            return this;
        }

        public ChartOfAccountBuilder parentCustomerCode(String parentCustomerCode) {
            this.parentCustomerCode = parentCustomerCode;
            return this;
        }

        public ChartOfAccountBuilder active(Boolean active) {
            this.active$value = active;
            this.active$set = true;
            return this;
        }

        public ChartOfAccountBuilder subType(ChartOfAccountSubType subType) {
            this.subType = subType;
            return this;
        }

        public ChartOfAccountBuilder openingBalance(@Nullable OpeningBalance openingBalance) {
            this.openingBalance = openingBalance;
            return this;
        }

        public ChartOfAccount build() {
            Boolean active$value = this.active$value;
            if (!this.active$set) {
                active$value = ChartOfAccount.$default$active();
            }
            return new ChartOfAccount(this.id, this.eventRefCode, this.name, this.currencyId, this.counterParty, this.parentCustomerCode, active$value, this.subType, this.openingBalance);
        }

        public String toString() {
            return "ChartOfAccount.ChartOfAccountBuilder(id=" + String.valueOf(this.id) + ", eventRefCode=" + this.eventRefCode + ", name=" + this.name + ", currencyId=" + this.currencyId + ", counterParty=" + this.counterParty + ", parentCustomerCode=" + this.parentCustomerCode + ", active$value=" + this.active$value + ", subType=" + String.valueOf((Object)this.subType) + ", openingBalance=" + String.valueOf(this.openingBalance) + ")";
        }
    }

    @Embeddable
    public static class Id {
        private String organisationId;
        private String customerCode;

        public Id(String organisationId, String customerCode) {
            this.organisationId = organisationId;
            this.customerCode = customerCode;
        }

        public Id() {
        }

        public String getOrganisationId() {
            return this.organisationId;
        }

        public String getCustomerCode() {
            return this.customerCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$organisationId = this.getOrganisationId();
            String other$organisationId = other.getOrganisationId();
            if (this$organisationId == null ? other$organisationId != null : !this$organisationId.equals(other$organisationId)) {
                return false;
            }
            String this$customerCode = this.getCustomerCode();
            String other$customerCode = other.getCustomerCode();
            return !(this$customerCode == null ? other$customerCode != null : !this$customerCode.equals(other$customerCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Id;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $organisationId = this.getOrganisationId();
            result = result * 59 + ($organisationId == null ? 43 : $organisationId.hashCode());
            String $customerCode = this.getCustomerCode();
            result = result * 59 + ($customerCode == null ? 43 : $customerCode.hashCode());
            return result;
        }
    }
}

