/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Table;
import org.hibernate.envers.Audited;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_account_event")
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class AccountEvent {
    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="organisationId", column=@Column(name="organisation_id")), @AttributeOverride(name="debitReferenceCode", column=@Column(name="debit_reference_code")), @AttributeOverride(name="creditReferenceCode", column=@Column(name="credit_reference_code"))})
    private Id id;
    @Column(nullable=false)
    private String name;
    private Boolean active;
    @Column(name="customer_code", nullable=false)
    private String customerCode;

    private static Boolean $default$active() {
        return Boolean.TRUE;
    }

    public static AccountEventBuilder builder() {
        return new AccountEventBuilder();
    }

    public AccountEvent(Id id, String name, Boolean active, String customerCode) {
        this.id = id;
        this.name = name;
        this.active = active;
        this.customerCode = customerCode;
    }

    public AccountEvent() {
        this.active = AccountEvent.$default$active();
    }

    public Id getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public String toString() {
        return "AccountEvent(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", active=" + this.getActive() + ", customerCode=" + this.getCustomerCode() + ")";
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public static class AccountEventBuilder {
        private Id id;
        private String name;
        private boolean active$set;
        private Boolean active$value;
        private String customerCode;

        AccountEventBuilder() {
        }

        public AccountEventBuilder id(Id id) {
            this.id = id;
            return this;
        }

        public AccountEventBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AccountEventBuilder active(Boolean active) {
            this.active$value = active;
            this.active$set = true;
            return this;
        }

        public AccountEventBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public AccountEvent build() {
            Boolean active$value = this.active$value;
            if (!this.active$set) {
                active$value = AccountEvent.$default$active();
            }
            return new AccountEvent(this.id, this.name, active$value, this.customerCode);
        }

        public String toString() {
            return "AccountEvent.AccountEventBuilder(id=" + String.valueOf(this.id) + ", name=" + this.name + ", active$value=" + this.active$value + ", customerCode=" + this.customerCode + ")";
        }
    }

    @Embeddable
    public static class Id {
        private String organisationId;
        private String debitReferenceCode;
        private String creditReferenceCode;

        public Id(String organisationId, String debitReferenceCode, String creditReferenceCode) {
            this.organisationId = organisationId;
            this.debitReferenceCode = debitReferenceCode;
            this.creditReferenceCode = creditReferenceCode;
        }

        public Id() {
        }

        public String getOrganisationId() {
            return this.organisationId;
        }

        public String getDebitReferenceCode() {
            return this.debitReferenceCode;
        }

        public String getCreditReferenceCode() {
            return this.creditReferenceCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$organisationId = this.getOrganisationId();
            String other$organisationId = other.getOrganisationId();
            if (this$organisationId == null ? other$organisationId != null : !this$organisationId.equals(other$organisationId)) {
                return false;
            }
            String this$debitReferenceCode = this.getDebitReferenceCode();
            String other$debitReferenceCode = other.getDebitReferenceCode();
            if (this$debitReferenceCode == null ? other$debitReferenceCode != null : !this$debitReferenceCode.equals(other$debitReferenceCode)) {
                return false;
            }
            String this$creditReferenceCode = this.getCreditReferenceCode();
            String other$creditReferenceCode = other.getCreditReferenceCode();
            return !(this$creditReferenceCode == null ? other$creditReferenceCode != null : !this$creditReferenceCode.equals(other$creditReferenceCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Id;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $organisationId = this.getOrganisationId();
            result = result * 59 + ($organisationId == null ? 43 : $organisationId.hashCode());
            String $debitReferenceCode = this.getDebitReferenceCode();
            result = result * 59 + ($debitReferenceCode == null ? 43 : $debitReferenceCode.hashCode());
            String $creditReferenceCode = this.getCreditReferenceCode();
            result = result * 59 + ($creditReferenceCode == null ? 43 : $creditReferenceCode.hashCode());
            return result;
        }
    }
}

