/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service;

import io.vavr.control.Either;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.entity.Vat;
import org.cardanofoundation.lob.app.organisation.domain.request.VatUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.VatView;
import org.cardanofoundation.lob.app.organisation.repository.VatRepository;
import org.cardanofoundation.lob.app.organisation.service.csv.CsvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

@Service
@Transactional(readOnly=true)
public class VatService {
    private static final Logger log = LoggerFactory.getLogger(VatService.class);
    private final VatRepository vatRepository;
    private final CsvParser<VatUpdate> csvParser;
    private final Validator validator;

    public Optional<Vat> findByOrganisationAndCode(String organisationId, String customerCode) {
        return this.vatRepository.findByIdAndActive(new Vat.Id(organisationId, customerCode), true);
    }

    public List<VatView> findAllByOrganisationId(String organisationId) {
        return this.vatRepository.findAllByOrganisationId(organisationId).stream().map(VatView::convertFromEntity).toList();
    }

    @Transactional
    public VatView insert(String organisationId, VatUpdate vatUpdate, boolean isUpsert) {
        Optional foundEntity = this.vatRepository.findById(new Vat.Id(organisationId, vatUpdate.getCustomerCode()));
        Vat vatEntity = new Vat();
        vatEntity.setId(new Vat.Id(organisationId, vatUpdate.getCustomerCode()));
        if (foundEntity.isPresent()) {
            if (isUpsert) {
                vatEntity = (Vat)((Object)foundEntity.get());
            } else {
                return VatView.createFail(vatUpdate, (Problem)Problem.builder().withTitle("ORGANISATION_VAT_ALREADY_EXISTS").withDetail("The organisation vat with code :%s already exists".formatted(vatUpdate.getCustomerCode())).withStatus((StatusType)Status.CONFLICT).build());
            }
        }
        if (vatUpdate.getCountryCode() != null && !Locale.getISOCountries(Locale.IsoCountryCode.PART1_ALPHA2).contains(vatUpdate.getCountryCode())) {
            return VatView.createFail(vatUpdate, (Problem)Problem.builder().withTitle("COUNTRY_CODE_NOT_FOUND").withDetail("The organisation vat country_code with code %s do not exists".formatted(vatUpdate.getCountryCode())).withStatus((StatusType)Status.NOT_FOUND).build());
        }
        vatEntity.setRate(vatUpdate.getRate());
        vatEntity.setDescription(vatUpdate.getDescription());
        vatEntity.setCountryCode(vatUpdate.getCountryCode() == null || vatUpdate.getCountryCode().isEmpty() ? null : vatUpdate.getCountryCode());
        vatEntity.setActive(Optional.ofNullable(vatUpdate.getActive()).orElse(true));
        return VatView.convertFromEntity((Vat)((Object)this.vatRepository.save((Object)vatEntity)));
    }

    @Transactional
    public VatView update(String organisationId, VatUpdate vatUpdate) {
        Optional organisationVat = this.vatRepository.findById(new Vat.Id(organisationId, vatUpdate.getCustomerCode()));
        if (organisationVat.isEmpty()) {
            return VatView.createFail(vatUpdate, (Problem)Problem.builder().withTitle("ORGANISATION_VAT_DO_NOT_EXISTS").withDetail("The organisation vat with code %s do not exists".formatted(vatUpdate.getCustomerCode())).withStatus((StatusType)Status.NOT_FOUND).build());
        }
        if (vatUpdate.getCountryCode() != null && !Locale.getISOCountries(Locale.IsoCountryCode.PART1_ALPHA2).contains(vatUpdate.getCountryCode())) {
            return VatView.createFail(vatUpdate, (Problem)Problem.builder().withTitle("COUNTRY_CODE_NOT_FOUND").withDetail("The organisation vat country_code with code %s do not exists".formatted(vatUpdate.getCountryCode())).withStatus((StatusType)Status.NOT_FOUND).build());
        }
        Vat vatEntity = (Vat)((Object)organisationVat.get());
        vatEntity.setRate(vatUpdate.getRate());
        vatEntity.setDescription(vatUpdate.getDescription());
        vatEntity.setCountryCode(vatUpdate.getCountryCode() == null || vatUpdate.getCountryCode().isEmpty() ? null : vatUpdate.getCountryCode());
        vatEntity.setActive(vatUpdate.getActive());
        return VatView.convertFromEntity((Vat)((Object)this.vatRepository.save((Object)vatEntity)));
    }

    @Transactional
    public Either<Problem, List<VatView>> insertVatCodesCsv(String organisationId, MultipartFile file) {
        return (Either)this.csvParser.parseCsv(file, VatUpdate.class).fold(Either::left, organisationVatUpdates -> Either.right(organisationVatUpdates.stream().map(vatUpdate -> {
            Errors errors = this.validator.validateObject(vatUpdate);
            List allErrors = errors.getAllErrors();
            if (!allErrors.isEmpty()) {
                return VatView.createFail(vatUpdate, (Problem)Problem.builder().withTitle("VALIDATION_ERROR").withDetail(allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "))).withStatus((StatusType)Status.BAD_REQUEST).build());
            }
            return this.insert(organisationId, (VatUpdate)vatUpdate, true);
        }).toList()));
    }

    public VatService(VatRepository vatRepository, CsvParser<VatUpdate> csvParser, Validator validator) {
        this.vatRepository = vatRepository;
        this.csvParser = csvParser;
        this.validator = validator;
    }
}

