/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service;

import io.vavr.control.Either;
import jakarta.validation.Valid;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.cardanofoundation.lob.app.organisation.domain.csv.ReportTypeFieldUpdateCsv;
import org.cardanofoundation.lob.app.organisation.domain.entity.ChartOfAccountSubType;
import org.cardanofoundation.lob.app.organisation.domain.entity.ReportTypeEntity;
import org.cardanofoundation.lob.app.organisation.domain.entity.ReportTypeFieldEntity;
import org.cardanofoundation.lob.app.organisation.domain.request.ReportTypeFieldUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.ReportTypeView;
import org.cardanofoundation.lob.app.organisation.repository.ChartOfAccountSubTypeRepository;
import org.cardanofoundation.lob.app.organisation.repository.ReportTypeFieldRepository;
import org.cardanofoundation.lob.app.organisation.repository.ReportTypeRepository;
import org.cardanofoundation.lob.app.organisation.service.csv.CsvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@Service
public class ReportTypeService {
    private static final Logger log = LoggerFactory.getLogger(ReportTypeService.class);
    private final ReportTypeRepository reportTypeRepository;
    private final ReportTypeFieldRepository reportTypeFieldRepository;
    private final ChartOfAccountSubTypeRepository chartOfAccountSubTypeRepository;
    private final CsvParser<ReportTypeFieldUpdateCsv> csvParser;

    @Transactional(readOnly=true)
    public List<ReportTypeView> getAllReportTypes(String orgId) {
        List<ReportTypeEntity> allByOrganisationId = this.reportTypeRepository.findAllByOrganisationId(orgId);
        return allByOrganisationId.stream().map(ReportTypeView::fromEntity).toList();
    }

    @Transactional
    public Either<Problem, Void> addMappingToReportTypeField(String orgId, @Valid ReportTypeFieldUpdate reportTypeFieldUpdate) {
        Optional<ReportTypeEntity> reportTypeEntityOptional = this.reportTypeRepository.findByOrganisationIdAndId(orgId, reportTypeFieldUpdate.getReportTypeId());
        if (reportTypeEntityOptional.isEmpty()) {
            return Either.left((Object)Problem.builder().withTitle("Report Type not found").withStatus((StatusType)Status.BAD_REQUEST).build());
        }
        Optional<ReportTypeFieldEntity> optionalReportField = this.reportTypeFieldRepository.findByReportIdAndId(reportTypeFieldUpdate.getReportTypeId(), reportTypeFieldUpdate.getReportTypeFieldId());
        if (optionalReportField.isEmpty()) {
            return Either.left((Object)Problem.builder().withTitle("Report Type Field not found").withStatus((StatusType)Status.BAD_REQUEST).build());
        }
        ReportTypeFieldEntity reportTypeFieldEntity = optionalReportField.get();
        Optional optionalSubType = this.chartOfAccountSubTypeRepository.findById(String.valueOf(reportTypeFieldUpdate.getOrganisationChartOfAccountSubTypeId()));
        if (optionalSubType.isEmpty()) {
            return Either.left((Object)Problem.builder().withTitle("Organisation Chart Of Account Sub Type not found").withStatus((StatusType)Status.BAD_REQUEST).build());
        }
        List<ChartOfAccountSubType> mappingTypes = reportTypeFieldEntity.getMappingTypes();
        mappingTypes.add((ChartOfAccountSubType)((Object)optionalSubType.get()));
        reportTypeFieldEntity.setMappingTypes(mappingTypes);
        this.reportTypeFieldRepository.saveAndFlush((Object)reportTypeFieldEntity);
        return Either.right(null);
    }

    @Transactional
    public Either<Set<Problem>, Void> addMappingToReportTypeFieldCsv(String orgId, MultipartFile file) {
        Either<Problem, List<ReportTypeFieldUpdateCsv>> csv = this.csvParser.parseCsv(file, ReportTypeFieldUpdateCsv.class);
        if (csv.isLeft()) {
            return Either.left(Set.of((Problem)csv.getLeft()));
        }
        List reportTypeFieldUpdateCsvs = (List)csv.get();
        HashSet<ThrowableProblem> errors = new HashSet<ThrowableProblem>();
        for (ReportTypeFieldUpdateCsv reportUpdate : reportTypeFieldUpdateCsvs) {
            ReportTypeFieldUpdate reportTypeFieldUpdate = new ReportTypeFieldUpdate(this.safeParse(reportUpdate.getReportType()), this.safeParse(reportUpdate.getReportTypeField()), this.safeParse(reportUpdate.getSubType()));
            Optional.ofNullable(reportUpdate.getReportType()).flatMap(reportTypeName -> this.reportTypeRepository.findByOrganisationAndReportName(orgId, (String)reportTypeName)).ifPresent(reportTypeEntity -> reportTypeFieldUpdate.setReportTypeId(reportTypeEntity.getId()));
            Optional.ofNullable(reportUpdate.getReportTypeField()).flatMap(reportTypeField -> this.reportTypeFieldRepository.findFirstByReportIdAndName(reportTypeFieldUpdate.getReportTypeId(), (String)reportTypeField)).ifPresent(reportTypeFieldEntity -> reportTypeFieldUpdate.setReportTypeFieldId(reportTypeFieldEntity.getId()));
            Optional.ofNullable(reportUpdate.getSubType()).flatMap(s -> this.chartOfAccountSubTypeRepository.findFirstByOrganisationIdAndName(orgId, (String)s)).ifPresent(organisationChartOfAccountSubType -> reportTypeFieldUpdate.setOrganisationChartOfAccountSubTypeId(organisationChartOfAccountSubType.getId()));
            if (reportTypeFieldUpdate.getReportTypeId() == null || reportTypeFieldUpdate.getReportTypeFieldId() == null || reportTypeFieldUpdate.getOrganisationChartOfAccountSubTypeId() == null) {
                errors.add(Problem.builder().withTitle("Can't add mappings to Report Type field: %s".formatted(reportUpdate)).withStatus((StatusType)Status.BAD_REQUEST).build());
                continue;
            }
            this.addMappingToReportTypeField(orgId, reportTypeFieldUpdate).peekLeft(errors::add);
        }
        if (errors.isEmpty()) {
            return Either.right(null);
        }
        return Either.left(errors);
    }

    private Long safeParse(String input) {
        try {
            return input == null || input.isBlank() ? null : Long.valueOf(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public ReportTypeService(ReportTypeRepository reportTypeRepository, ReportTypeFieldRepository reportTypeFieldRepository, ChartOfAccountSubTypeRepository chartOfAccountSubTypeRepository, CsvParser<ReportTypeFieldUpdateCsv> csvParser) {
        this.reportTypeRepository = reportTypeRepository;
        this.reportTypeFieldRepository = reportTypeFieldRepository;
        this.chartOfAccountSubTypeRepository = chartOfAccountSubTypeRepository;
        this.csvParser = csvParser;
    }
}

