/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service;

import io.vavr.control.Either;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.entity.Organisation;
import org.cardanofoundation.lob.app.organisation.domain.entity.ReferenceCode;
import org.cardanofoundation.lob.app.organisation.domain.request.ReferenceCodeUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.ReferenceCodeView;
import org.cardanofoundation.lob.app.organisation.repository.ReferenceCodeRepository;
import org.cardanofoundation.lob.app.organisation.service.AccountEventService;
import org.cardanofoundation.lob.app.organisation.service.OrganisationService;
import org.cardanofoundation.lob.app.organisation.service.csv.CsvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

@Service
@Transactional(readOnly=true)
public class ReferenceCodeService {
    private static final Logger log = LoggerFactory.getLogger(ReferenceCodeService.class);
    private final ReferenceCodeRepository referenceCodeRepository;
    private final OrganisationService organisationService;
    private final CsvParser<ReferenceCodeUpdate> csvParser;
    private final AccountEventService accountEventService;
    private final Validator validator;

    public List<ReferenceCodeView> getAllReferenceCodes(String orgId) {
        return this.referenceCodeRepository.findAllByOrgId(orgId).stream().map(ReferenceCodeView::fromEntity).toList();
    }

    public Optional<ReferenceCodeView> getReferenceCode(String orgId, String referenceCode) {
        return this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, referenceCode).map(ReferenceCodeView::fromEntity);
    }

    @Transactional
    public ReferenceCodeView insertReferenceCode(String orgId, ReferenceCodeUpdate referenceCodeUpdate, boolean isUpsert) {
        Optional<Organisation> organisationChe = this.organisationService.findById(orgId);
        if (organisationChe.isEmpty()) {
            return ReferenceCodeView.createFail((Problem)Problem.builder().withTitle("ORGANISATION_NOT_FOUND").withDetail("Unable to find Organisation by Id: %s".formatted(orgId)).withStatus((StatusType)Status.NOT_FOUND).build(), referenceCodeUpdate);
        }
        if (referenceCodeUpdate.getParentReferenceCode() != null && !referenceCodeUpdate.getParentReferenceCode().isEmpty()) {
            Optional<ReferenceCode> parentReferenceCode = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, referenceCodeUpdate.getParentReferenceCode());
            if (parentReferenceCode.isEmpty()) {
                return ReferenceCodeView.createFail((Problem)Problem.builder().withTitle("PARENT_REFERENCE_CODE_NOT_FOUND").withDetail("Unable to find parent reference Id: %s".formatted(referenceCodeUpdate.getParentReferenceCode())).withStatus((StatusType)Status.NOT_FOUND).build(), referenceCodeUpdate);
            }
            if (parentReferenceCode.get().getId().getReferenceCode().equals(referenceCodeUpdate.getReferenceCode())) {
                return ReferenceCodeView.createFail((Problem)Problem.builder().withTitle("PARENT_REFERENCE_CODE_CANNOT_BE_SELF").withDetail("The parent reference code cannot be the same as the reference code itself :%s".formatted(referenceCodeUpdate.getReferenceCode())).withStatus((StatusType)Status.BAD_REQUEST).build(), referenceCodeUpdate);
            }
        }
        Optional<ReferenceCode> referenceCodeOpt = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, referenceCodeUpdate.getReferenceCode());
        ReferenceCode referenceCode = ReferenceCode.builder().id(new ReferenceCode.Id(orgId, referenceCodeUpdate.getReferenceCode())).build();
        if (referenceCodeOpt.isPresent()) {
            if (isUpsert) {
                referenceCode = referenceCodeOpt.get();
            } else {
                return ReferenceCodeView.createFail((Problem)Problem.builder().withTitle("REFERENCE_CODE_ALREADY_EXIST").withDetail("The reference code with code :%s already exists".formatted(referenceCodeUpdate.getReferenceCode())).withStatus((StatusType)Status.CONFLICT).build(), referenceCodeUpdate);
            }
        }
        referenceCode.setName(referenceCodeUpdate.getName());
        referenceCode.setParentReferenceCode(referenceCodeUpdate.getParentReferenceCode() == null || referenceCodeUpdate.getParentReferenceCode().isEmpty() ? null : referenceCodeUpdate.getParentReferenceCode());
        referenceCode.setActive(referenceCodeUpdate.getActive());
        ReferenceCode savedEntity = (ReferenceCode)((Object)this.referenceCodeRepository.save((Object)referenceCode));
        this.accountEventService.updateStatus(orgId, savedEntity.getId().getReferenceCode());
        return ReferenceCodeView.fromEntity(savedEntity);
    }

    @Transactional
    public ReferenceCodeView updateReferenceCode(String orgId, ReferenceCodeUpdate referenceCodeUpdate) {
        Optional<ReferenceCode> referenceCodeOpt;
        Optional<Organisation> organisationChe = this.organisationService.findById(orgId);
        if (organisationChe.isEmpty()) {
            return ReferenceCodeView.createFail((Problem)Problem.builder().withTitle("ORGANISATION_NOT_FOUND").withDetail("Unable to find Organisation by Id: %s".formatted(orgId)).withStatus((StatusType)Status.NOT_FOUND).build(), referenceCodeUpdate);
        }
        if (referenceCodeUpdate.getParentReferenceCode() != null && !referenceCodeUpdate.getParentReferenceCode().isEmpty()) {
            Optional<ReferenceCode> parentReferenceCode = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, referenceCodeUpdate.getParentReferenceCode());
            if (parentReferenceCode.isEmpty()) {
                return ReferenceCodeView.createFail((Problem)Problem.builder().withTitle("PARENT_REFERENCE_CODE_NOT_FOUND").withDetail("Unable to find parent reference Id: %s".formatted(referenceCodeUpdate.getParentReferenceCode())).withStatus((StatusType)Status.NOT_FOUND).build(), referenceCodeUpdate);
            }
            if (parentReferenceCode.get().getId().getReferenceCode().equals(referenceCodeUpdate.getReferenceCode())) {
                return ReferenceCodeView.createFail((Problem)Problem.builder().withTitle("PARENT_REFERENCE_CODE_CANNOT_BE_SELF").withDetail("The parent reference code cannot be the same as the reference code itself :%s".formatted(referenceCodeUpdate.getReferenceCode())).withStatus((StatusType)Status.BAD_REQUEST).build(), referenceCodeUpdate);
            }
        }
        if ((referenceCodeOpt = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, referenceCodeUpdate.getReferenceCode())).isEmpty()) {
            return ReferenceCodeView.createFail((Problem)Problem.builder().withTitle("REFERENCE_CODE_NOT_FOUND").withDetail("Unable to find reference Id: %s".formatted(referenceCodeUpdate.getReferenceCode())).withStatus((StatusType)Status.NOT_FOUND).build(), referenceCodeUpdate);
        }
        ReferenceCode referenceCode = referenceCodeOpt.get();
        referenceCode.setName(referenceCodeUpdate.getName());
        referenceCode.setParentReferenceCode(referenceCodeUpdate.getParentReferenceCode() == null || referenceCodeUpdate.getParentReferenceCode().isEmpty() ? null : referenceCodeUpdate.getParentReferenceCode());
        referenceCode.setActive(referenceCodeUpdate.getActive());
        referenceCode = (ReferenceCode)((Object)this.referenceCodeRepository.save((Object)referenceCode));
        this.accountEventService.updateStatus(orgId, referenceCode.getId().getReferenceCode());
        return ReferenceCodeView.fromEntity(referenceCode);
    }

    @Transactional
    public Either<Set<Problem>, Set<ReferenceCodeView>> insertReferenceCodeByCsv(String orgId, MultipartFile file) {
        return (Either)this.csvParser.parseCsv(file, ReferenceCodeUpdate.class).fold(problem -> Either.left(Set.of(problem)), referenceCodeUpdates -> Either.right(referenceCodeUpdates.stream().map(refCodeUpdate -> {
            Errors errors = this.validator.validateObject(refCodeUpdate);
            List allErrors = errors.getAllErrors();
            if (!allErrors.isEmpty()) {
                return ReferenceCodeView.createFail((Problem)Problem.builder().withTitle("VALIDATION_ERROR").withDetail(allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "))).withStatus((StatusType)Status.BAD_REQUEST).build(), refCodeUpdate);
            }
            return this.insertReferenceCode(orgId, (ReferenceCodeUpdate)refCodeUpdate, true);
        }).collect(Collectors.toSet())));
    }

    public ReferenceCodeService(ReferenceCodeRepository referenceCodeRepository, OrganisationService organisationService, CsvParser<ReferenceCodeUpdate> csvParser, AccountEventService accountEventService, Validator validator) {
        this.referenceCodeRepository = referenceCodeRepository;
        this.organisationService = organisationService;
        this.csvParser = csvParser;
        this.accountEventService = accountEventService;
        this.validator = validator;
    }
}

