/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service;

import io.vavr.control.Either;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.csv.ProjectUpdate;
import org.cardanofoundation.lob.app.organisation.domain.entity.Project;
import org.cardanofoundation.lob.app.organisation.domain.view.ProjectView;
import org.cardanofoundation.lob.app.organisation.repository.ProjectMappingRepository;
import org.cardanofoundation.lob.app.organisation.service.csv.CsvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

@Service
@Transactional(readOnly=true)
public class ProjectCodeService {
    private static final Logger log = LoggerFactory.getLogger(ProjectCodeService.class);
    private final ProjectMappingRepository projectMappingRepository;
    private final CsvParser<ProjectUpdate> csvParser;
    private final Validator validator;

    public Optional<Project> getProject(String organisationId, String customerCode) {
        return this.projectMappingRepository.findById(new Project.Id(organisationId, customerCode));
    }

    public Set<Project> getAllProjects(String organisationId) {
        return this.projectMappingRepository.findAllByOrganisationId(organisationId);
    }

    @Transactional
    public ProjectView insertProject(String orgId, ProjectUpdate projectUpdate, boolean isUpsert) {
        Optional<Project> projectFound = this.getProject(orgId, projectUpdate.getCustomerCode());
        Project project = new Project();
        project.setId(new Project.Id(orgId, projectUpdate.getCustomerCode()));
        if (projectFound.isPresent()) {
            if (isUpsert) {
                project = projectFound.get();
            } else {
                return ProjectView.createFail(projectUpdate, (Problem)Problem.builder().withStatus((StatusType)Status.CONFLICT).withTitle("PROJECT_CODE_ALREADY_EXISTS").withDetail("Project code with customer code %s already exists.".formatted(projectUpdate.getCustomerCode())).build());
            }
        }
        project.setName(projectUpdate.getName());
        if (projectUpdate.getParentCustomerCode() != null) {
            Optional<Project> parent = this.getProject(orgId, projectUpdate.getParentCustomerCode());
            if (parent.isPresent()) {
                if (parent.get().getId().getCustomerCode().equals(projectUpdate.getCustomerCode())) {
                    return ProjectView.createFail(projectUpdate, (Problem)Problem.builder().withStatus((StatusType)Status.BAD_REQUEST).withTitle("PARENT_PROJECT_CANNOT_BE_SELF").withDetail("The parent project cannot be the same as the project itself :%s".formatted(projectUpdate.getCustomerCode())).build());
                }
                project.setParentCustomerCode(Objects.requireNonNull(parent.get().getId()).getCustomerCode());
            } else {
                return ProjectView.createFail(projectUpdate, (Problem)Problem.builder().withStatus((StatusType)Status.NOT_FOUND).withTitle("PARENT_PROJECT_CODE_NOT_FOUND").withDetail("Parent project code with customer code %s not found.".formatted(projectUpdate.getParentCustomerCode())).build());
            }
        }
        Project saved = (Project)((Object)this.projectMappingRepository.save((Object)project));
        return ProjectView.fromEntity(saved);
    }

    @Transactional
    public ProjectView updateProject(String orgId, ProjectUpdate projectUpdate) {
        Optional<Project> projectFound = this.getProject(orgId, projectUpdate.getCustomerCode());
        if (projectFound.isPresent()) {
            Project projectEntityUpdated = projectFound.get();
            projectEntityUpdated.setName(projectUpdate.getName());
            if (projectUpdate.getParentCustomerCode() != null) {
                Optional<Project> project = this.getProject(orgId, projectUpdate.getParentCustomerCode());
                if (project.isPresent()) {
                    if (project.get().getId().getCustomerCode().equals(projectUpdate.getCustomerCode())) {
                        return ProjectView.createFail(projectUpdate, (Problem)Problem.builder().withStatus((StatusType)Status.BAD_REQUEST).withTitle("PARENT_PROJECT_CANNOT_BE_SELF").withDetail("The parent project cannot be the same as the project itself :%s".formatted(projectUpdate.getCustomerCode())).build());
                    }
                    projectEntityUpdated.setParentCustomerCode(Objects.requireNonNull(project.get().getId()).getCustomerCode());
                } else {
                    return ProjectView.createFail(projectUpdate, (Problem)Problem.builder().withStatus((StatusType)Status.NOT_FOUND).withTitle("PARENT_PROJECT_CODE_NOT_FOUND").withDetail("Parent project code with customer code %s not found.".formatted(projectUpdate.getParentCustomerCode())).build());
                }
            }
            return ProjectView.fromEntity((Project)((Object)this.projectMappingRepository.save((Object)projectEntityUpdated)));
        }
        return ProjectView.createFail(projectUpdate, (Problem)Problem.builder().withStatus((StatusType)Status.NOT_FOUND).withTitle("PROJECT_CODE_NOT_FOUND").withDetail("Project code with customer code %s not found.".formatted(projectUpdate.getCustomerCode())).build());
    }

    @Transactional
    public Either<Problem, List<ProjectView>> createProjectCodeFromCsv(String orgId, MultipartFile file) {
        return (Either)this.csvParser.parseCsv(file, ProjectUpdate.class).fold(Either::left, projectUpdates -> Either.right(projectUpdates.stream().map(projectUpdate -> {
            Errors errors = this.validator.validateObject(projectUpdate);
            List allErrors = errors.getAllErrors();
            if (!allErrors.isEmpty()) {
                return ProjectView.createFail(projectUpdate, (Problem)Problem.builder().withTitle("VALIDATION_ERROR").withDetail(allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "))).withStatus((StatusType)Status.BAD_REQUEST).build());
            }
            return this.insertProject(orgId, (ProjectUpdate)projectUpdate, true);
        }).toList()));
    }

    public ProjectCodeService(ProjectMappingRepository projectMappingRepository, CsvParser<ProjectUpdate> csvParser, Validator validator) {
        this.projectMappingRepository = projectMappingRepository;
        this.csvParser = csvParser;
        this.validator = validator;
    }
}

