/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service;

import io.vavr.control.Either;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.entity.Currency;
import org.cardanofoundation.lob.app.organisation.domain.request.CurrencyUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.CurrencyView;
import org.cardanofoundation.lob.app.organisation.repository.CurrencyRepository;
import org.cardanofoundation.lob.app.organisation.service.csv.CsvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@Service
public class CurrencyService {
    private static final Logger log = LoggerFactory.getLogger(CurrencyService.class);
    private final CurrencyRepository currencyRepository;
    private final CsvParser<CurrencyUpdate> csvParser;
    private final Validator validator;

    public List<CurrencyView> getAllCurrencies(String orgId) {
        return this.currencyRepository.findAllByOrganisationId(orgId).stream().map(currency -> CurrencyView.createSuccess(currency.getId().getCustomerCode(), currency.getCurrencyId())).toList();
    }

    public Optional<Currency> findByOrganisationIdAndCode(@Param(value="organisationId") String organisationId, @Param(value="customerCode") String customerCode) {
        return this.currencyRepository.findById(new Currency.Id(organisationId, customerCode));
    }

    public Set<Currency> findAllByOrganisationId(@Param(value="organisationId") String organisationId) {
        return this.currencyRepository.findAllByOrganisationId(organisationId);
    }

    public CurrencyView updateCurrency(String orgId, @Valid CurrencyUpdate currencyUpdate) {
        return this.currencyRepository.findById(new Currency.Id(orgId, currencyUpdate.getCustomerCode())).map(currency -> {
            currency.setCurrencyId(currencyUpdate.getCurrencyId());
            Currency updatedEntity = (Currency)((Object)((Object)this.currencyRepository.save(currency)));
            return CurrencyView.createSuccess(updatedEntity.getId().getCustomerCode(), updatedEntity.getCurrencyId());
        }).orElseGet(() -> {
            ThrowableProblem error = Problem.builder().withStatus((StatusType)Status.NOT_FOUND).withTitle("CURRENCY_NOT_FOUND").withDetail("Currency with customer code " + currencyUpdate.getCustomerCode() + " not found").build();
            return CurrencyView.createFail((Problem)error, currencyUpdate);
        });
    }

    public CurrencyView insertCurrency(String orgId, @Valid CurrencyUpdate currencyUpdate, boolean isUpsert) {
        Optional currencyFound = this.currencyRepository.findById(new Currency.Id(orgId, currencyUpdate.getCustomerCode()));
        Currency currency = new Currency(new Currency.Id(orgId, currencyUpdate.getCustomerCode()), currencyUpdate.getCurrencyId());
        if (currencyFound.isPresent()) {
            if (isUpsert) {
                currency = (Currency)((Object)currencyFound.get());
                currency.setCurrencyId(currency.getCurrencyId());
            } else {
                ThrowableProblem error = Problem.builder().withStatus((StatusType)Status.CONFLICT).withTitle("CURRENCY_ALREADY_EXISTS").withDetail("Currency with customer code " + currencyUpdate.getCustomerCode() + " already exists").build();
                return CurrencyView.createFail((Problem)error, currencyUpdate);
            }
        }
        Currency save = (Currency)((Object)this.currencyRepository.save((Object)currency));
        return CurrencyView.createSuccess(save.getId().getCustomerCode(), save.getCurrencyId());
    }

    public Optional<CurrencyView> getCurrency(String orgId, String customerCode) {
        return this.currencyRepository.findById(new Currency.Id(orgId, customerCode)).map(currency -> CurrencyView.createSuccess(currency.getId().getCustomerCode(), currency.getCurrencyId()));
    }

    public Either<Problem, List<CurrencyView>> insertViaCsv(String orgId, MultipartFile file) {
        return (Either)this.csvParser.parseCsv(file, CurrencyUpdate.class).fold(Either::left, currencyUpdates -> Either.right(currencyUpdates.stream().map(currencyUpdate -> {
            Errors errors = this.validator.validateObject(currencyUpdate);
            List allErrors = errors.getAllErrors();
            if (!allErrors.isEmpty()) {
                return CurrencyView.createFail((Problem)Problem.builder().withTitle("VALIDATION_ERROR").withDetail(allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "))).withStatus((StatusType)Status.BAD_REQUEST).build(), currencyUpdate);
            }
            return this.insertCurrency(orgId, (CurrencyUpdate)currencyUpdate, true);
        }).toList()));
    }

    public CurrencyService(CurrencyRepository currencyRepository, CsvParser<CurrencyUpdate> csvParser, Validator validator) {
        this.currencyRepository = currencyRepository;
        this.csvParser = csvParser;
        this.validator = validator;
    }
}

