/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service;

import io.vavr.control.Either;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.csv.ChartOfAccountUpdateCsv;
import org.cardanofoundation.lob.app.organisation.domain.entity.ChartOfAccount;
import org.cardanofoundation.lob.app.organisation.domain.entity.ChartOfAccountSubType;
import org.cardanofoundation.lob.app.organisation.domain.entity.ChartOfAccountType;
import org.cardanofoundation.lob.app.organisation.domain.entity.Currency;
import org.cardanofoundation.lob.app.organisation.domain.entity.Organisation;
import org.cardanofoundation.lob.app.organisation.domain.entity.ReferenceCode;
import org.cardanofoundation.lob.app.organisation.domain.request.ChartOfAccountUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.ChartOfAccountView;
import org.cardanofoundation.lob.app.organisation.repository.ChartOfAccountRepository;
import org.cardanofoundation.lob.app.organisation.repository.ChartOfAccountSubTypeRepository;
import org.cardanofoundation.lob.app.organisation.repository.ChartOfAccountTypeRepository;
import org.cardanofoundation.lob.app.organisation.repository.CurrencyRepository;
import org.cardanofoundation.lob.app.organisation.repository.ReferenceCodeRepository;
import org.cardanofoundation.lob.app.organisation.service.OrganisationService;
import org.cardanofoundation.lob.app.organisation.service.csv.CsvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@Service
@Transactional(readOnly=true)
public class ChartOfAccountsService {
    private static final Logger log = LoggerFactory.getLogger(ChartOfAccountsService.class);
    private final ChartOfAccountRepository chartOfAccountRepository;
    private final ChartOfAccountTypeRepository chartOfAccountTypeRepository;
    private final ChartOfAccountSubTypeRepository chartOfAccountSubTypeRepository;
    private final ReferenceCodeRepository referenceCodeRepository;
    private final CurrencyRepository currencyRepository;
    private final OrganisationService organisationService;
    private final CsvParser<ChartOfAccountUpdateCsv> csvParser;
    private final Validator validator;
    @PersistenceContext
    private EntityManager entityManager;

    public Optional<ChartOfAccount> getChartAccount(String organisationId, String customerCode) {
        return this.chartOfAccountRepository.findByIdAndActive(new ChartOfAccount.Id(organisationId, customerCode), true);
    }

    @Transactional
    public Set<ChartOfAccountType> getAllChartType(String organisationId) {
        return this.chartOfAccountTypeRepository.findAllByOrganisationId(organisationId);
    }

    public Set<ChartOfAccount> getBySubTypeId(Long subType) {
        return this.chartOfAccountRepository.findAllByOrganisationIdSubTypeId(subType);
    }

    public Set<ChartOfAccountView> getAllChartOfAccount(String organisationId) {
        return this.chartOfAccountRepository.findAllByOrganisationId(organisationId).stream().map(ChartOfAccountView::createSuccess).collect(Collectors.toSet());
    }

    @Transactional
    public ChartOfAccountView updateChartOfAccount(String orgId, ChartOfAccountUpdate chartOfAccountUpdate) {
        Either<ChartOfAccountView, Void> organisationAvaliable = this.isOrganisationAvaliable(orgId, chartOfAccountUpdate);
        if (organisationAvaliable.isLeft()) {
            return (ChartOfAccountView)organisationAvaliable.getLeft();
        }
        Either<ChartOfAccountView, Void> referenceCodeAvailable = this.isReferenceCodeAvailable(orgId, chartOfAccountUpdate);
        if (referenceCodeAvailable.isLeft()) {
            return (ChartOfAccountView)referenceCodeAvailable.getLeft();
        }
        Either<ChartOfAccountView, ChartOfAccountSubType> subType = this.isSubTypeAvailable(orgId, chartOfAccountUpdate);
        if (subType.isLeft()) {
            return (ChartOfAccountView)subType.getLeft();
        }
        Either<ChartOfAccountView, Void> parentCodeAvailable = this.isParentCodeAvailable(orgId, chartOfAccountUpdate);
        if (parentCodeAvailable.isLeft()) {
            return (ChartOfAccountView)parentCodeAvailable.getLeft();
        }
        Either<ChartOfAccountView, ChartOfAccount> chartOfAccountOpt = this.isChartOfAccountAvailable(orgId, chartOfAccountUpdate);
        if (chartOfAccountOpt.isLeft()) {
            return (ChartOfAccountView)chartOfAccountOpt.getLeft();
        }
        ChartOfAccount chartOfAccount = (ChartOfAccount)((Object)chartOfAccountOpt.get());
        return this.updateAndSaveChartOfAccount(chartOfAccountUpdate, subType, chartOfAccount);
    }

    private Either<ChartOfAccountView, ChartOfAccount> isChartOfAccountAvailable(String orgId, ChartOfAccountUpdate chartOfAccountUpdate) {
        Optional<ChartOfAccount> chartOfAccountOpt = this.chartOfAccountRepository.findAllByOrganisationIdAndReferenceCode(orgId, chartOfAccountUpdate.getCustomerCode());
        if (chartOfAccountOpt.isEmpty()) {
            return Either.left((Object)ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("CHART_OF_ACCOUNT_NOT_FOUND").withDetail("Unable to find the chart of account with code :%s".formatted(chartOfAccountUpdate.getCustomerCode())).withStatus((StatusType)Status.NOT_FOUND).build(), chartOfAccountUpdate));
        }
        return Either.right((Object)((Object)chartOfAccountOpt.get()));
    }

    private Either<ChartOfAccountView, Void> isOrganisationAvaliable(String orgId, ChartOfAccountUpdate chartOfAccountUpdate) {
        Optional<Organisation> organisationChe = this.organisationService.findById(orgId);
        if (organisationChe.isEmpty()) {
            return Either.left((Object)ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("ORGANISATION_NOT_FOUND").withDetail("Unable to find Organisation by Id: %s".formatted(orgId)).withStatus((StatusType)Status.NOT_FOUND).build(), chartOfAccountUpdate));
        }
        return Either.right(null);
    }

    private Either<ChartOfAccountView, Void> isReferenceCodeAvailable(String orgId, ChartOfAccountUpdate chartOfAccountUpdate) {
        Optional<ReferenceCode> referenceCode = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, chartOfAccountUpdate.getEventRefCode());
        if (referenceCode.isEmpty()) {
            return Either.left((Object)ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("REFERENCE_CODE_NOT_FOUND").withDetail("Unable to find event ref code: %s".formatted(chartOfAccountUpdate.getEventRefCode())).withStatus((StatusType)Status.NOT_FOUND).build(), chartOfAccountUpdate));
        }
        return Either.right(null);
    }

    private Either<ChartOfAccountView, ChartOfAccountSubType> isSubTypeAvailable(String orgId, ChartOfAccountUpdate chartOfAccountUpdate) {
        Optional<ChartOfAccountSubType> subType = this.chartOfAccountSubTypeRepository.findAllByOrganisationIdAndSubTypeId(orgId, chartOfAccountUpdate.getSubType());
        return subType.map(Either::right).orElseGet(() -> Either.left((Object)ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("SUBTYPE_NOT_FOUND").withDetail("Unable to find subtype code :%s".formatted(chartOfAccountUpdate.getSubType())).withStatus((StatusType)Status.NOT_FOUND).build(), chartOfAccountUpdate)));
    }

    Either<ChartOfAccountView, Void> isParentCodeAvailable(String orgId, ChartOfAccountUpdate chartOfAccountUpdate) {
        if (chartOfAccountUpdate.getParentCustomerCode() != null && !chartOfAccountUpdate.getParentCustomerCode().isEmpty()) {
            Optional<ChartOfAccount> parentChartOfAccount = this.chartOfAccountRepository.findAllByOrganisationIdAndReferenceCode(orgId, chartOfAccountUpdate.getParentCustomerCode());
            if (parentChartOfAccount.isEmpty()) {
                return Either.left((Object)ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("PARENT_ACCOUNT_NOT_FOUND").withDetail("Unable to find the parent chart of account with code :%s".formatted(chartOfAccountUpdate.getParentCustomerCode())).withStatus((StatusType)Status.NOT_FOUND).build(), chartOfAccountUpdate));
            }
            if (parentChartOfAccount.get().getId().getCustomerCode().equals(chartOfAccountUpdate.getCustomerCode())) {
                return Either.left((Object)ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("PARENT_ACCOUNT_CANNOT_BE_SELF").withDetail("The parent chart of account cannot be the same as the account itself :%s".formatted(chartOfAccountUpdate.getCustomerCode())).withStatus((StatusType)Status.BAD_REQUEST).build(), chartOfAccountUpdate));
            }
        }
        return Either.right(null);
    }

    @Transactional
    public ChartOfAccountView insertChartOfAccount(String orgId, ChartOfAccountUpdate chartOfAccountUpdate, boolean isUpsert) {
        Either<ChartOfAccountView, Void> organisationAvaliable = this.isOrganisationAvaliable(orgId, chartOfAccountUpdate);
        if (organisationAvaliable.isLeft()) {
            return (ChartOfAccountView)organisationAvaliable.getLeft();
        }
        Either<ChartOfAccountView, Void> referenceCodeAvailable = this.isReferenceCodeAvailable(orgId, chartOfAccountUpdate);
        if (referenceCodeAvailable.isLeft()) {
            return (ChartOfAccountView)referenceCodeAvailable.getLeft();
        }
        Either<ChartOfAccountView, Void> parentCodeAvailable = this.isParentCodeAvailable(orgId, chartOfAccountUpdate);
        if (parentCodeAvailable.isLeft()) {
            return (ChartOfAccountView)parentCodeAvailable.getLeft();
        }
        Either<ChartOfAccountView, ChartOfAccountSubType> subTypeAvailable = this.isSubTypeAvailable(orgId, chartOfAccountUpdate);
        if (subTypeAvailable.isLeft()) {
            return (ChartOfAccountView)subTypeAvailable.getLeft();
        }
        Optional<ChartOfAccount> chartOfAccountOpt = this.chartOfAccountRepository.findAllByOrganisationIdAndReferenceCode(orgId, chartOfAccountUpdate.getCustomerCode());
        ChartOfAccount chartOfAccount = ChartOfAccount.builder().id(new ChartOfAccount.Id(orgId, chartOfAccountUpdate.getCustomerCode())).build();
        if (chartOfAccountOpt.isPresent()) {
            if (isUpsert) {
                chartOfAccount = chartOfAccountOpt.get();
            } else {
                return ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("CHART_OF_ACCOUNT_ALREADY_EXISTS").withDetail("The chart of account with code :%s already exists".formatted(chartOfAccountUpdate.getCustomerCode())).withStatus((StatusType)Status.CONFLICT).build(), chartOfAccountUpdate);
            }
        }
        return this.updateAndSaveChartOfAccount(chartOfAccountUpdate, subTypeAvailable, chartOfAccount);
    }

    private ChartOfAccountView updateAndSaveChartOfAccount(ChartOfAccountUpdate chartOfAccountUpdate, Either<ChartOfAccountView, ChartOfAccountSubType> subType, ChartOfAccount chartOfAccount) {
        Optional byId;
        chartOfAccount.setName(chartOfAccountUpdate.getName());
        chartOfAccount.setEventRefCode(chartOfAccountUpdate.getEventRefCode());
        chartOfAccount.setSubType((ChartOfAccountSubType)((Object)subType.get()));
        chartOfAccount.setParentCustomerCode(chartOfAccountUpdate.getParentCustomerCode() == null || chartOfAccountUpdate.getParentCustomerCode().isEmpty() ? null : chartOfAccountUpdate.getParentCustomerCode());
        String currency = Optional.ofNullable(chartOfAccountUpdate.getCurrency()).orElse("");
        if (!currency.isEmpty() && (byId = this.currencyRepository.findById(new Currency.Id(chartOfAccount.getId().getOrganisationId(), currency))).isEmpty()) {
            return ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("CURRENCY_NOT_FOUND").withDetail("Unable to find currency with id: %s".formatted(currency)).withStatus((StatusType)Status.NOT_FOUND).build(), chartOfAccountUpdate);
        }
        chartOfAccount.setCurrencyId(chartOfAccountUpdate.getCurrency());
        chartOfAccount.setCounterParty(chartOfAccountUpdate.getCounterParty());
        chartOfAccount.setActive(chartOfAccountUpdate.getActive());
        if (Optional.ofNullable(chartOfAccountUpdate.getOpeningBalance()).isPresent() && !chartOfAccountUpdate.getOpeningBalance().allNull()) {
            Errors errors = this.validator.validateObject((Object)chartOfAccountUpdate.getOpeningBalance());
            List allErrors = errors.getAllErrors();
            if (!allErrors.isEmpty()) {
                ThrowableProblem error = Problem.builder().withTitle("OPENING_BALANCE_VALIDATION_ERROR").withDetail(allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "))).withStatus((StatusType)Status.BAD_REQUEST).build();
                return ChartOfAccountView.createFail((Problem)error, chartOfAccountUpdate);
            }
            if (!chartOfAccountUpdate.getOpeningBalance().getOriginalCurrencyIdFCY().equals(chartOfAccountUpdate.getCurrency())) {
                return ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("OPENING_BALANCE_CURRENCY_MISMATCH").withDetail("The opening balance FCY currency must match the chart of account currency.").withStatus((StatusType)Status.BAD_REQUEST).build(), chartOfAccountUpdate);
            }
            Organisation organisation = this.organisationService.findById(chartOfAccount.getId().getOrganisationId()).orElseThrow();
            Currency organisationCurrency = this.currencyRepository.findByCurrencyId(chartOfAccount.getId().getOrganisationId(), organisation.getCurrencyId()).orElseThrow(() -> new RuntimeException("Organisation currency not found"));
            if (!chartOfAccountUpdate.getOpeningBalance().getOriginalCurrencyIdLCY().equals(organisationCurrency.getId().getCustomerCode())) {
                return ChartOfAccountView.createFail((Problem)Problem.builder().withTitle("OPENING_BALANCE_CURRENCY_MISMATCH").withDetail("The opening balance LCY currency must match the organisation currency: %s".formatted(organisationCurrency.getId().getCustomerCode())).withStatus((StatusType)Status.BAD_REQUEST).build(), chartOfAccountUpdate);
            }
        }
        chartOfAccount.setOpeningBalance(chartOfAccountUpdate.getOpeningBalance());
        ChartOfAccount chartOfAccountResult = (ChartOfAccount)((Object)this.chartOfAccountRepository.save((Object)chartOfAccount));
        return ChartOfAccountView.createSuccess(chartOfAccountResult);
    }

    @Transactional
    public Either<Set<Problem>, Set<ChartOfAccountView>> insertChartOfAccountByCsv(String orgId, MultipartFile file) {
        Either<Problem, List<ChartOfAccountUpdateCsv>> lists = this.csvParser.parseCsv(file, ChartOfAccountUpdateCsv.class);
        if (lists.isLeft()) {
            return Either.left(Set.of((Problem)lists.getLeft()));
        }
        List chartOfAccountUpdates = (List)lists.get();
        HashSet<ChartOfAccountView> accountEventViews = new HashSet<ChartOfAccountView>();
        for (ChartOfAccountUpdateCsv chartOfAccountUpdateCsv : chartOfAccountUpdates) {
            ThrowableProblem error;
            Errors errors = this.validator.validateObject((Object)chartOfAccountUpdateCsv);
            List allErrors = errors.getAllErrors();
            if (!allErrors.isEmpty()) {
                ThrowableProblem error2 = Problem.builder().withTitle("VALIDATION_ERROR").withDetail(allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "))).withStatus((StatusType)Status.BAD_REQUEST).build();
                accountEventViews.add(ChartOfAccountView.createFail((Problem)error2, chartOfAccountUpdateCsv));
                continue;
            }
            try {
                chartOfAccountUpdateCsv.fillOpeningBalance();
            }
            catch (Exception e) {
                error = Problem.builder().withTitle("OPENING_BALANCE_ERROR").withDetail(e.getMessage()).withStatus((StatusType)Status.BAD_REQUEST).build();
                accountEventViews.add(ChartOfAccountView.createFail((Problem)error, chartOfAccountUpdateCsv));
                continue;
            }
            Optional<ChartOfAccountType> type = this.chartOfAccountTypeRepository.findFirstByOrganisationIdAndName(orgId, chartOfAccountUpdateCsv.getType());
            if (type.isEmpty()) {
                error = Problem.builder().withTitle("CHART_OF_ACCOUNT_TYPE_NOT_FOUND").withDetail("Chart of account type: %s not found. Please provide a valid type.".formatted(chartOfAccountUpdateCsv.getType())).withStatus((StatusType)Status.BAD_REQUEST).build();
                accountEventViews.add(ChartOfAccountView.createFail((Problem)error, chartOfAccountUpdateCsv));
                continue;
            }
            Optional<ChartOfAccountSubType> subType = this.chartOfAccountSubTypeRepository.findFirstByNameAndOrganisationIdAndParentName(orgId, chartOfAccountUpdateCsv.getSubType(), chartOfAccountUpdateCsv.getType());
            if (subType.isEmpty()) {
                ThrowableProblem error3 = Problem.builder().withTitle("CHART_OF_ACCOUNT_SUBTYPE_NOT_FOUND").withDetail("Chart of account subtype: %s not found for type: %s. Please provide a valid subtype.".formatted(chartOfAccountUpdateCsv.getSubType(), chartOfAccountUpdateCsv.getType())).withStatus((StatusType)Status.BAD_REQUEST).build();
                accountEventViews.add(ChartOfAccountView.createFail((Problem)error3, chartOfAccountUpdateCsv));
                continue;
            }
            chartOfAccountUpdateCsv.setType(String.valueOf(type.get().getId()));
            chartOfAccountUpdateCsv.setSubType(String.valueOf(subType.get().getId()));
            ChartOfAccountView accountEventView = this.insertChartOfAccount(orgId, chartOfAccountUpdateCsv, true);
            accountEventViews.add(accountEventView);
        }
        return Either.right(accountEventViews);
    }

    private ChartOfAccountSubType saveTypeAndSubType(String orgId, ChartOfAccountUpdateCsv chartOfAccountUpdateCsv) {
        ChartOfAccountType chartOfAccountType = ChartOfAccountType.builder().organisationId(orgId).name(chartOfAccountUpdateCsv.getType()).build();
        ChartOfAccountSubType chartOfAccountSubType = ChartOfAccountSubType.builder().organisationId(orgId).name(chartOfAccountUpdateCsv.getSubType()).type(chartOfAccountType).build();
        chartOfAccountType.setSubTypes(Set.of(chartOfAccountSubType));
        ChartOfAccountType save = (ChartOfAccountType)((Object)this.chartOfAccountTypeRepository.save((Object)chartOfAccountType));
        return (ChartOfAccountSubType)((Object)save.getSubTypes().stream().iterator().next());
    }

    public ChartOfAccountsService(ChartOfAccountRepository chartOfAccountRepository, ChartOfAccountTypeRepository chartOfAccountTypeRepository, ChartOfAccountSubTypeRepository chartOfAccountSubTypeRepository, ReferenceCodeRepository referenceCodeRepository, CurrencyRepository currencyRepository, OrganisationService organisationService, CsvParser<ChartOfAccountUpdateCsv> csvParser, Validator validator) {
        this.chartOfAccountRepository = chartOfAccountRepository;
        this.chartOfAccountTypeRepository = chartOfAccountTypeRepository;
        this.chartOfAccountSubTypeRepository = chartOfAccountSubTypeRepository;
        this.referenceCodeRepository = referenceCodeRepository;
        this.currencyRepository = currencyRepository;
        this.organisationService = organisationService;
        this.csvParser = csvParser;
        this.validator = validator;
    }
}

