/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.resource;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import org.cardanofoundation.lob.app.organisation.domain.request.VatUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.VatView;
import org.cardanofoundation.lob.app.organisation.service.VatService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

@RestController
@RequestMapping(value={"/api/v1/organisations"})
@Tag(name="Organisation", description="Organisation API")
@CrossOrigin(origins={"http://localhost:3000"})
@ConditionalOnProperty(value={"lob.organisation.enabled"}, havingValue="true", matchIfMissing=true)
public class VatController {
    private final VatService vatService;

    @Operation(description="Vat Codes", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=VatView.class)))})})
    @GetMapping(value={"/{orgId}/vat-codes"}, produces={"application/json"})
    public ResponseEntity<List<VatView>> getVatCodes(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        return ResponseEntity.ok().body(this.vatService.findAllByOrganisationId(orgId));
    }

    @Operation(description="Vat code insert", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=VatView.class))})})
    @PostMapping(value={"/{orgId}/vat-codes"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> insertVatCode(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody VatUpdate vatUpdate) {
        VatView vatView = this.vatService.insert(orgId, vatUpdate, false);
        return vatView.getError().map(error -> ResponseEntity.status((int)Optional.ofNullable(error.getStatus()).map(StatusType::getStatusCode).orElse(Status.BAD_REQUEST.getStatusCode())).body((Object)vatView)).orElse(ResponseEntity.ok((Object)vatView));
    }

    @Operation(description="Reference Code update", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=VatUpdate.class))})})
    @PutMapping(value={"/{orgId}/vat-codes"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> updateReferenceCode(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody VatUpdate vatUpdate) {
        VatView vatView = this.vatService.update(orgId, vatUpdate);
        return vatView.getError().map(error -> ResponseEntity.status((int)Optional.ofNullable(error.getStatus()).map(StatusType::getStatusCode).orElse(Status.BAD_REQUEST.getStatusCode())).body((Object)vatView)).orElse(ResponseEntity.ok((Object)vatView));
    }

    @Operation(description="Vat codes insert via csv", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=VatView.class))})})
    @PostMapping(value={"/{orgId}/vat-codes"}, produces={"application/json"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> insertVatCodesCsv(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @RequestParam(value="file") MultipartFile file) {
        return (ResponseEntity)this.vatService.insertVatCodesCsv(orgId, file).fold(problem -> ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(problem), ResponseEntity::ok);
    }

    public VatController(VatService vatService) {
        this.vatService = vatService;
    }
}

