/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.resource;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vavr.control.Either;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Set;
import org.cardanofoundation.lob.app.organisation.domain.request.ReferenceCodeUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.ReferenceCodeView;
import org.cardanofoundation.lob.app.organisation.service.OrganisationService;
import org.cardanofoundation.lob.app.organisation.service.ReferenceCodeService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;

@RestController
@RequestMapping(value={"/api/v1/organisations"})
@Tag(name="Organisation", description="Organisation API")
@CrossOrigin(origins={"http://localhost:3000"})
@ConditionalOnProperty(value={"lob.organisation.enabled"}, havingValue="true", matchIfMissing=true)
public class ReferenceCodeResource {
    private final ReferenceCodeService referenceCodeService;
    private final OrganisationService organisationService;

    @Operation(description="Reference Codes list", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ReferenceCodeView.class)))})})
    @GetMapping(value={"/{orgId}/reference-codes"}, produces={"application/json"})
    public List<ReferenceCodeView> getReferenceCodes(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        return this.referenceCodeService.getAllReferenceCodes(orgId);
    }

    @Operation(description="Reference Code insert", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ReferenceCodeView.class)))})})
    @PostMapping(value={"/{orgId}/reference-codes"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> insertReferenceCode(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody ReferenceCodeUpdate referenceCodeUpdate) {
        ReferenceCodeView referenceCode = this.referenceCodeService.insertReferenceCode(orgId, referenceCodeUpdate, false);
        if (referenceCode.getError().isPresent()) {
            return ResponseEntity.status((int)referenceCode.getError().get().getStatus().getStatusCode()).body((Object)referenceCode);
        }
        return ResponseEntity.ok((Object)referenceCode);
    }

    @Operation(description="Reference Code insert by CSV", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ReferenceCodeView.class)))})})
    @PostMapping(value={"/{orgId}/reference-codes"}, consumes={"multipart/form-data"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> insertRefCodeByCsv(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @RequestParam(value="file") MultipartFile file) {
        Either<Set<Problem>, Set<ReferenceCodeView>> refCodeE = this.referenceCodeService.insertReferenceCodeByCsv(orgId, file);
        if (refCodeE.isLeft()) {
            return ResponseEntity.status((int)Status.BAD_REQUEST.getStatusCode()).body((Object)((Set)refCodeE.getLeft()));
        }
        Set referenceCodeViews = (Set)refCodeE.get();
        return ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).body((Object)referenceCodeViews);
    }

    @Operation(description="Reference Code update", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=ReferenceCodeView.class)))})})
    @PutMapping(value={"/{orgId}/reference-codes"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> updateReferenceCode(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody ReferenceCodeUpdate referenceCodeUpdate) {
        ReferenceCodeView referenceCode = this.referenceCodeService.updateReferenceCode(orgId, referenceCodeUpdate);
        if (referenceCode.getError().isPresent()) {
            return ResponseEntity.status((int)referenceCode.getError().get().getStatus().getStatusCode()).body((Object)referenceCode);
        }
        return ResponseEntity.ok((Object)referenceCode);
    }

    public ReferenceCodeResource(ReferenceCodeService referenceCodeService, OrganisationService organisationService) {
        this.referenceCodeService = referenceCodeService;
        this.organisationService = organisationService;
    }
}

