/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.resource;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.csv.CostCenterUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.CostCenterView;
import org.cardanofoundation.lob.app.organisation.service.CostCenterService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

@RestController
@RequestMapping(value={"/api/v1"})
@Tag(name="Organisation", description="Organisation API")
@CrossOrigin(origins={"http://localhost:3000"})
@ConditionalOnProperty(value={"lob.organisation.enabled"}, havingValue="true", matchIfMissing=true)
public class CostCenterController {
    private final CostCenterService costCenterService;

    @Operation(description="Organisation cost center", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CostCenterView.class)))})})
    @GetMapping(value={"/organisations/{orgId}/cost-centers"}, produces={"application/json"})
    public ResponseEntity<Set<CostCenterView>> getAllCostCenters(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        return ResponseEntity.ok().body(this.costCenterService.getAllCostCenter(orgId).stream().map(CostCenterView::fromEntity).collect(Collectors.toSet()));
    }

    @Operation(description="Organisation cost center creation", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CostCenterView.class)))})})
    @PostMapping(value={"/organisations/{orgId}/cost-centers"}, produces={"application/json"}, consumes={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAdminRole()) or hasRole(@securityConfig.getAccountantRole())")
    public ResponseEntity<CostCenterView> insertCostCenters(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody CostCenterUpdate costCenterUpdate) {
        CostCenterView costCenterView = this.costCenterService.insertCostCenter(orgId, costCenterUpdate, false);
        return costCenterView.getError().map(error -> ResponseEntity.status((int)Optional.ofNullable(error.getStatus()).map(StatusType::getStatusCode).orElse(Status.BAD_REQUEST.getStatusCode())).body((Object)costCenterView)).orElse(ResponseEntity.ok((Object)costCenterView));
    }

    @Operation(description="Organisation cost center update", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CostCenterView.class)))})})
    @PutMapping(value={"/organisations/{orgId}/cost-centers"}, produces={"application/json"}, consumes={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAdminRole()) or hasRole(@securityConfig.getAccountantRole())")
    public ResponseEntity<CostCenterView> updateCostCenters(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody CostCenterUpdate costCenterUpdate) {
        CostCenterView costCenterView = this.costCenterService.updateCostCenter(orgId, costCenterUpdate);
        return costCenterView.getError().map(error -> ResponseEntity.status((int)Optional.ofNullable(error.getStatus()).map(StatusType::getStatusCode).orElse(Status.BAD_REQUEST.getStatusCode())).body((Object)costCenterView)).orElse(ResponseEntity.ok((Object)costCenterView));
    }

    @Operation(description="Organisation cost center creation csv", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=CostCenterView.class)))})})
    @PostMapping(value={"/organisations/{orgId}/cost-centers"}, produces={"application/json"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAdminRole()) or hasRole(@securityConfig.getAccountantRole())")
    public ResponseEntity<?> insertCostCentersCsv(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @RequestParam(value="file") MultipartFile file) {
        return (ResponseEntity)this.costCenterService.createCostCenterFromCsv(orgId, file).fold(problem -> ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body(problem), ResponseEntity::ok);
    }

    public CostCenterController(CostCenterService costCenterService) {
        this.costCenterService = costCenterService;
    }
}

