/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.view;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.csv.CostCenterUpdate;
import org.cardanofoundation.lob.app.organisation.domain.entity.CostCenter;
import org.zalando.problem.Problem;

public class CostCenterView {
    private String customerCode;
    private String name;
    private CostCenterView parent;
    private Set<CostCenterView> children;
    private String parentCustomerCode;
    private boolean active;
    private Optional<Problem> error;

    public static CostCenterView fromEntity(CostCenter costCenter) {
        CostCenterViewBuilder builder = CostCenterView.builder().customerCode(costCenter.getId() == null ? null : costCenter.getId().getCustomerCode()).name(costCenter.getName()).active(costCenter.isActive()).error(Optional.empty());
        if (costCenter.getParent().isPresent()) {
            builder.parent(CostCenterView.fromEntityWithoutParentAndChildren(costCenter.getParent().get()));
        }
        if (!costCenter.getChildren().isEmpty()) {
            builder.children(costCenter.getChildren().stream().map(CostCenterView::fromEntityWithoutParentAndChildren).collect(Collectors.toSet()));
        }
        return builder.build();
    }

    public static CostCenterView fromEntityWithoutParentAndChildren(CostCenter costCenter) {
        return CostCenterView.builder().customerCode(costCenter.getId() == null ? null : costCenter.getId().getCustomerCode()).name(costCenter.getName()).active(costCenter.isActive()).error(Optional.empty()).build();
    }

    public static CostCenterView createFail(CostCenterUpdate costCenterUpdate, Problem error) {
        return CostCenterView.builder().customerCode(costCenterUpdate.getCustomerCode()).name(costCenterUpdate.getName()).parentCustomerCode(costCenterUpdate.getParentCustomerCode()).active(Optional.ofNullable(costCenterUpdate.getActive()).orElse(false)).error(Optional.of(error)).build();
    }

    public static CostCenterViewBuilder builder() {
        return new CostCenterViewBuilder();
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getName() {
        return this.name;
    }

    public CostCenterView getParent() {
        return this.parent;
    }

    public Set<CostCenterView> getChildren() {
        return this.children;
    }

    public String getParentCustomerCode() {
        return this.parentCustomerCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public Optional<Problem> getError() {
        return this.error;
    }

    public CostCenterView(String customerCode, String name, CostCenterView parent, Set<CostCenterView> children, String parentCustomerCode, boolean active, Optional<Problem> error) {
        this.customerCode = customerCode;
        this.name = name;
        this.parent = parent;
        this.children = children;
        this.parentCustomerCode = parentCustomerCode;
        this.active = active;
        this.error = error;
    }

    public static class CostCenterViewBuilder {
        private String customerCode;
        private String name;
        private CostCenterView parent;
        private Set<CostCenterView> children;
        private String parentCustomerCode;
        private boolean active;
        private Optional<Problem> error;

        CostCenterViewBuilder() {
        }

        public CostCenterViewBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public CostCenterViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CostCenterViewBuilder parent(CostCenterView parent) {
            this.parent = parent;
            return this;
        }

        public CostCenterViewBuilder children(Set<CostCenterView> children) {
            this.children = children;
            return this;
        }

        public CostCenterViewBuilder parentCustomerCode(String parentCustomerCode) {
            this.parentCustomerCode = parentCustomerCode;
            return this;
        }

        public CostCenterViewBuilder active(boolean active) {
            this.active = active;
            return this;
        }

        public CostCenterViewBuilder error(Optional<Problem> error) {
            this.error = error;
            return this;
        }

        public CostCenterView build() {
            return new CostCenterView(this.customerCode, this.name, this.parent, this.children, this.parentCustomerCode, this.active, this.error);
        }

        public String toString() {
            return "CostCenterView.CostCenterViewBuilder(customerCode=" + this.customerCode + ", name=" + this.name + ", parent=" + String.valueOf(this.parent) + ", children=" + String.valueOf(this.children) + ", parentCustomerCode=" + this.parentCustomerCode + ", active=" + this.active + ", error=" + String.valueOf(this.error) + ")";
        }
    }
}

