/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.view;

import java.util.Optional;
import org.cardanofoundation.lob.app.organisation.domain.entity.ChartOfAccount;
import org.cardanofoundation.lob.app.organisation.domain.entity.OpeningBalance;
import org.cardanofoundation.lob.app.organisation.domain.request.ChartOfAccountUpdate;
import org.zalando.problem.Problem;

public class ChartOfAccountView {
    private String customerCode;
    private String eventRefCode;
    private String name;
    private Long subType;
    private String subTypeName;
    private Long type;
    private String typeName;
    private String currency;
    private String counterParty;
    private Boolean active;
    private String parentCustomerCode;
    private OpeningBalance openingBalance;
    private Optional<Problem> error;

    public static ChartOfAccountView createSuccess(ChartOfAccount chartOfAccount) {
        if (chartOfAccount.getSubType() != null) {
            return ChartOfAccountView.builder().customerCode(chartOfAccount.getId().getCustomerCode()).eventRefCode(chartOfAccount.getEventRefCode()).name(chartOfAccount.getName()).subType(chartOfAccount.getSubType().getId()).type(chartOfAccount.getSubType().getType().getId()).currency(chartOfAccount.getCurrencyId()).counterParty(chartOfAccount.getCounterParty()).active(chartOfAccount.getActive()).openingBalance(chartOfAccount.getOpeningBalance()).parentCustomerCode(chartOfAccount.getParentCustomerCode()).error(Optional.empty()).build();
        }
        return ChartOfAccountView.builder().customerCode(chartOfAccount.getId().getCustomerCode()).eventRefCode(chartOfAccount.getEventRefCode()).name(chartOfAccount.getName()).counterParty(chartOfAccount.getCounterParty()).currency(chartOfAccount.getCurrencyId()).active(chartOfAccount.getActive()).parentCustomerCode(chartOfAccount.getParentCustomerCode()).openingBalance(chartOfAccount.getOpeningBalance()).build();
    }

    public static ChartOfAccountView createFail(Problem error, ChartOfAccountUpdate chartOfAccountUpdate) {
        return ChartOfAccountView.builder().customerCode(chartOfAccountUpdate.getCustomerCode()).eventRefCode(chartOfAccountUpdate.getEventRefCode()).name(chartOfAccountUpdate.getName()).typeName(chartOfAccountUpdate.getType()).subTypeName(chartOfAccountUpdate.getSubType()).currency(chartOfAccountUpdate.getCurrency()).counterParty(chartOfAccountUpdate.getCounterParty()).active(chartOfAccountUpdate.getActive()).parentCustomerCode(chartOfAccountUpdate.getParentCustomerCode()).openingBalance(chartOfAccountUpdate.getOpeningBalance()).error(Optional.of(error)).build();
    }

    public static ChartOfAccountViewBuilder builder() {
        return new ChartOfAccountViewBuilder();
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getEventRefCode() {
        return this.eventRefCode;
    }

    public String getName() {
        return this.name;
    }

    public Long getSubType() {
        return this.subType;
    }

    public String getSubTypeName() {
        return this.subTypeName;
    }

    public Long getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getCounterParty() {
        return this.counterParty;
    }

    public Boolean getActive() {
        return this.active;
    }

    public String getParentCustomerCode() {
        return this.parentCustomerCode;
    }

    public OpeningBalance getOpeningBalance() {
        return this.openingBalance;
    }

    public Optional<Problem> getError() {
        return this.error;
    }

    public ChartOfAccountView(String customerCode, String eventRefCode, String name, Long subType, String subTypeName, Long type, String typeName, String currency, String counterParty, Boolean active, String parentCustomerCode, OpeningBalance openingBalance, Optional<Problem> error) {
        this.customerCode = customerCode;
        this.eventRefCode = eventRefCode;
        this.name = name;
        this.subType = subType;
        this.subTypeName = subTypeName;
        this.type = type;
        this.typeName = typeName;
        this.currency = currency;
        this.counterParty = counterParty;
        this.active = active;
        this.parentCustomerCode = parentCustomerCode;
        this.openingBalance = openingBalance;
        this.error = error;
    }

    public static class ChartOfAccountViewBuilder {
        private String customerCode;
        private String eventRefCode;
        private String name;
        private Long subType;
        private String subTypeName;
        private Long type;
        private String typeName;
        private String currency;
        private String counterParty;
        private Boolean active;
        private String parentCustomerCode;
        private OpeningBalance openingBalance;
        private Optional<Problem> error;

        ChartOfAccountViewBuilder() {
        }

        public ChartOfAccountViewBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public ChartOfAccountViewBuilder eventRefCode(String eventRefCode) {
            this.eventRefCode = eventRefCode;
            return this;
        }

        public ChartOfAccountViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChartOfAccountViewBuilder subType(Long subType) {
            this.subType = subType;
            return this;
        }

        public ChartOfAccountViewBuilder subTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
            return this;
        }

        public ChartOfAccountViewBuilder type(Long type) {
            this.type = type;
            return this;
        }

        public ChartOfAccountViewBuilder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public ChartOfAccountViewBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public ChartOfAccountViewBuilder counterParty(String counterParty) {
            this.counterParty = counterParty;
            return this;
        }

        public ChartOfAccountViewBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public ChartOfAccountViewBuilder parentCustomerCode(String parentCustomerCode) {
            this.parentCustomerCode = parentCustomerCode;
            return this;
        }

        public ChartOfAccountViewBuilder openingBalance(OpeningBalance openingBalance) {
            this.openingBalance = openingBalance;
            return this;
        }

        public ChartOfAccountViewBuilder error(Optional<Problem> error) {
            this.error = error;
            return this;
        }

        public ChartOfAccountView build() {
            return new ChartOfAccountView(this.customerCode, this.eventRefCode, this.name, this.subType, this.subTypeName, this.type, this.typeName, this.currency, this.counterParty, this.active, this.parentCustomerCode, this.openingBalance, this.error);
        }

        public String toString() {
            return "ChartOfAccountView.ChartOfAccountViewBuilder(customerCode=" + this.customerCode + ", eventRefCode=" + this.eventRefCode + ", name=" + this.name + ", subType=" + this.subType + ", subTypeName=" + this.subTypeName + ", type=" + this.type + ", typeName=" + this.typeName + ", currency=" + this.currency + ", counterParty=" + this.counterParty + ", active=" + this.active + ", parentCustomerCode=" + this.parentCustomerCode + ", openingBalance=" + String.valueOf(this.openingBalance) + ", error=" + String.valueOf(this.error) + ")";
        }
    }
}

