/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.envers.Audited;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_vat")
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class Vat
extends CommonEntity
implements Persistable<Id> {
    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="organisationId", column=@Column(name="organisation_id")), @AttributeOverride(name="customerCode", column=@Column(name="customer_code"))})
    private Id id;
    @Column(name="rate", nullable=false)
    private BigDecimal rate;
    @Column(name="description")
    private String description;
    @Column(name="country_code")
    private String countryCode;
    @Column(name="active", nullable=false)
    private Boolean active;

    private static Boolean $default$active() {
        return true;
    }

    public static VatBuilder builder() {
        return new VatBuilder();
    }

    public Vat(Id id, BigDecimal rate, String description, String countryCode, Boolean active) {
        this.id = id;
        this.rate = rate;
        this.description = description;
        this.countryCode = countryCode;
        this.active = active;
    }

    public Vat() {
        this.active = Vat.$default$active();
    }

    public Id getId() {
        return this.id;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public static class VatBuilder {
        private Id id;
        private BigDecimal rate;
        private String description;
        private String countryCode;
        private boolean active$set;
        private Boolean active$value;

        VatBuilder() {
        }

        public VatBuilder id(Id id) {
            this.id = id;
            return this;
        }

        public VatBuilder rate(BigDecimal rate) {
            this.rate = rate;
            return this;
        }

        public VatBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VatBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public VatBuilder active(Boolean active) {
            this.active$value = active;
            this.active$set = true;
            return this;
        }

        public Vat build() {
            Boolean active$value = this.active$value;
            if (!this.active$set) {
                active$value = Vat.$default$active();
            }
            return new Vat(this.id, this.rate, this.description, this.countryCode, active$value);
        }

        public String toString() {
            return "Vat.VatBuilder(id=" + String.valueOf(this.id) + ", rate=" + String.valueOf(this.rate) + ", description=" + this.description + ", countryCode=" + this.countryCode + ", active$value=" + this.active$value + ")";
        }
    }

    @Embeddable
    public static class Id {
        private String organisationId;
        private String customerCode;

        public Id(String organisationId, String customerCode) {
            this.organisationId = organisationId;
            this.customerCode = customerCode;
        }

        public Id() {
        }

        public String getOrganisationId() {
            return this.organisationId;
        }

        public String getCustomerCode() {
            return this.customerCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$organisationId = this.getOrganisationId();
            String other$organisationId = other.getOrganisationId();
            if (this$organisationId == null ? other$organisationId != null : !this$organisationId.equals(other$organisationId)) {
                return false;
            }
            String this$customerCode = this.getCustomerCode();
            String other$customerCode = other.getCustomerCode();
            return !(this$customerCode == null ? other$customerCode != null : !this$customerCode.equals(other$customerCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Id;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $organisationId = this.getOrganisationId();
            result = result * 59 + ($organisationId == null ? 43 : $organisationId.hashCode());
            String $customerCode = this.getCustomerCode();
            result = result * 59 + ($customerCode == null ? 43 : $customerCode.hashCode());
            return result;
        }
    }
}

