/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;
import org.cardanofoundation.lob.app.organisation.domain.entity.ReportTypeFieldEntity;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.envers.Audited;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_report_setup", uniqueConstraints={@UniqueConstraint(columnNames={"organisation_id", "name"})})
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class ReportTypeEntity
extends CommonEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="organisation_id", nullable=false)
    private String organisationId;
    @Column(name="name", nullable=false)
    private String name;
    @OneToMany(mappedBy="report", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private List<ReportTypeFieldEntity> fields;

    private static List<ReportTypeFieldEntity> $default$fields() {
        return new ArrayList<ReportTypeFieldEntity>();
    }

    public static ReportTypeEntityBuilder builder() {
        return new ReportTypeEntityBuilder();
    }

    public ReportTypeEntity(Long id, String organisationId, String name, List<ReportTypeFieldEntity> fields) {
        this.id = id;
        this.organisationId = organisationId;
        this.name = name;
        this.fields = fields;
    }

    public ReportTypeEntity() {
        this.fields = ReportTypeEntity.$default$fields();
    }

    public Long getId() {
        return this.id;
    }

    public String getOrganisationId() {
        return this.organisationId;
    }

    public String getName() {
        return this.name;
    }

    public List<ReportTypeFieldEntity> getFields() {
        return this.fields;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrganisationId(String organisationId) {
        this.organisationId = organisationId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFields(List<ReportTypeFieldEntity> fields) {
        this.fields = fields;
    }

    public static class ReportTypeEntityBuilder {
        private Long id;
        private String organisationId;
        private String name;
        private boolean fields$set;
        private List<ReportTypeFieldEntity> fields$value;

        ReportTypeEntityBuilder() {
        }

        public ReportTypeEntityBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ReportTypeEntityBuilder organisationId(String organisationId) {
            this.organisationId = organisationId;
            return this;
        }

        public ReportTypeEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ReportTypeEntityBuilder fields(List<ReportTypeFieldEntity> fields) {
            this.fields$value = fields;
            this.fields$set = true;
            return this;
        }

        public ReportTypeEntity build() {
            List<ReportTypeFieldEntity> fields$value = this.fields$value;
            if (!this.fields$set) {
                fields$value = ReportTypeEntity.$default$fields();
            }
            return new ReportTypeEntity(this.id, this.organisationId, this.name, fields$value);
        }

        public String toString() {
            return "ReportTypeEntity.ReportTypeEntityBuilder(id=" + this.id + ", organisationId=" + this.organisationId + ", name=" + this.name + ", fields$value=" + String.valueOf(this.fields$value) + ")";
        }
    }
}

