/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import io.hypersistence.utils.hibernate.type.basic.PostgreSQLCITextType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.util.Optional;
import org.cardanofoundation.lob.app.support.crypto.SHA3;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.annotations.Type;
import org.hibernate.envers.Audited;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation")
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class Organisation
extends CommonEntity
implements Persistable<String> {
    @Id
    @Column(name="organisation_id", nullable=false)
    private String id;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="city", nullable=false)
    private String city;
    @Column(name="post_code", nullable=false)
    private String postCode;
    @Column(name="province", nullable=false)
    private String province;
    @Column(name="address", nullable=false)
    private String address;
    @Column(name="phone_number")
    private String phoneNumber;
    @Column(name="tax_id_number", nullable=false)
    private String taxIdNumber;
    @Column(name="country_code", nullable=false)
    private String countryCode;
    @Column(name="dummy_account")
    private String dummyAccount;
    @Column(name="pre_approve_transactions")
    private Boolean preApproveTransactions;
    @Column(name="pre_approve_transactions_dispatch")
    private Boolean preApproveTransactionsDispatch;
    @Column(name="accounting_period_days", nullable=false)
    private int accountPeriodDays;
    @Column(name="currency_id", nullable=false)
    private String currencyId;
    @Column(name="report_currency_id", nullable=false)
    private String reportCurrencyId;
    @Column(name="website_url")
    private String websiteUrl;
    @Column(name="admin_email", nullable=false)
    private String adminEmail;
    @Lob
    @Type(value=PostgreSQLCITextType.class)
    @Column(name="logo")
    private String logo;

    public static String id(String countryCode, String taxIdNumber) {
        return SHA3.digestAsHex((String)"%s::%s".formatted(countryCode, taxIdNumber));
    }

    public boolean isPreApproveTransactionsEnabled() {
        return Optional.ofNullable(this.preApproveTransactions).orElse(false);
    }

    public boolean isPreApproveTransactionsDispatchEnabled() {
        return Optional.ofNullable(this.preApproveTransactionsDispatch).orElse(false);
    }

    public Optional<String> getDummyAccount() {
        return Optional.ofNullable(this.dummyAccount);
    }

    public Organisation(String id, String name, String city, String postCode, String province, String address, String phoneNumber, String taxIdNumber, String countryCode, String dummyAccount, Boolean preApproveTransactions, Boolean preApproveTransactionsDispatch, int accountPeriodDays, String currencyId, String reportCurrencyId, String websiteUrl, String adminEmail, String logo) {
        this.id = id;
        this.name = name;
        this.city = city;
        this.postCode = postCode;
        this.province = province;
        this.address = address;
        this.phoneNumber = phoneNumber;
        this.taxIdNumber = taxIdNumber;
        this.countryCode = countryCode;
        this.dummyAccount = dummyAccount;
        this.preApproveTransactions = preApproveTransactions;
        this.preApproveTransactionsDispatch = preApproveTransactionsDispatch;
        this.accountPeriodDays = accountPeriodDays;
        this.currencyId = currencyId;
        this.reportCurrencyId = reportCurrencyId;
        this.websiteUrl = websiteUrl;
        this.adminEmail = adminEmail;
        this.logo = logo;
    }

    public Organisation() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getCity() {
        return this.city;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public String getProvince() {
        return this.province;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getTaxIdNumber() {
        return this.taxIdNumber;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public Boolean getPreApproveTransactions() {
        return this.preApproveTransactions;
    }

    public Boolean getPreApproveTransactionsDispatch() {
        return this.preApproveTransactionsDispatch;
    }

    public int getAccountPeriodDays() {
        return this.accountPeriodDays;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public String getReportCurrencyId() {
        return this.reportCurrencyId;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setTaxIdNumber(String taxIdNumber) {
        this.taxIdNumber = taxIdNumber;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void setDummyAccount(String dummyAccount) {
        this.dummyAccount = dummyAccount;
    }

    public void setPreApproveTransactions(Boolean preApproveTransactions) {
        this.preApproveTransactions = preApproveTransactions;
    }

    public void setPreApproveTransactionsDispatch(Boolean preApproveTransactionsDispatch) {
        this.preApproveTransactionsDispatch = preApproveTransactionsDispatch;
    }

    public void setAccountPeriodDays(int accountPeriodDays) {
        this.accountPeriodDays = accountPeriodDays;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public void setReportCurrencyId(String reportCurrencyId) {
        this.reportCurrencyId = reportCurrencyId;
    }

    public void setWebsiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }
}

