/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.opencsv.bean.CsvBindByName;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.cardanofoundation.lob.app.organisation.domain.core.OperationType;

@Embeddable
public class OpeningBalance {
    @CsvBindByName(column="Balance FCY")
    @NotNull(message="Balance FCY is required")
    private @NotNull(message="Balance FCY is required") BigDecimal balanceFCY;
    @CsvBindByName(column="Balance LCY")
    @NotNull(message="Balance LCY is required")
    private @NotNull(message="Balance LCY is required") BigDecimal balanceLCY;
    @CsvBindByName(column="Original Currency ID FCY")
    @NotNull(message="Original Currency ID FCY is required")
    private @NotNull(message="Original Currency ID FCY is required") String originalCurrencyIdFCY;
    @CsvBindByName(column="Original Currency ID LCY")
    @NotNull(message="Original Currency ID LCY is required")
    private @NotNull(message="Original Currency ID LCY is required") String originalCurrencyIdLCY;
    @Enumerated(value=EnumType.STRING)
    @CsvBindByName(column="Balance Type")
    @NotNull(message="Balance Type is required")
    private @NotNull(message="Balance Type is required") OperationType balanceType;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    @CsvBindByName(column="Balance Date")
    @NotNull(message="Balance Date is required")
    private @NotNull(message="Balance Date is required") LocalDate date;

    public boolean allNull() {
        return this.balanceFCY == null && this.balanceLCY == null && this.originalCurrencyIdFCY == null && this.originalCurrencyIdLCY == null && this.balanceType == null && this.date == null;
    }

    public static OpeningBalanceBuilder builder() {
        return new OpeningBalanceBuilder();
    }

    public OpeningBalanceBuilder toBuilder() {
        return new OpeningBalanceBuilder().balanceFCY(this.balanceFCY).balanceLCY(this.balanceLCY).originalCurrencyIdFCY(this.originalCurrencyIdFCY).originalCurrencyIdLCY(this.originalCurrencyIdLCY).balanceType(this.balanceType).date(this.date);
    }

    public OpeningBalance() {
    }

    public OpeningBalance(BigDecimal balanceFCY, BigDecimal balanceLCY, String originalCurrencyIdFCY, String originalCurrencyIdLCY, OperationType balanceType, LocalDate date) {
        this.balanceFCY = balanceFCY;
        this.balanceLCY = balanceLCY;
        this.originalCurrencyIdFCY = originalCurrencyIdFCY;
        this.originalCurrencyIdLCY = originalCurrencyIdLCY;
        this.balanceType = balanceType;
        this.date = date;
    }

    public BigDecimal getBalanceFCY() {
        return this.balanceFCY;
    }

    public BigDecimal getBalanceLCY() {
        return this.balanceLCY;
    }

    public String getOriginalCurrencyIdFCY() {
        return this.originalCurrencyIdFCY;
    }

    public String getOriginalCurrencyIdLCY() {
        return this.originalCurrencyIdLCY;
    }

    public OperationType getBalanceType() {
        return this.balanceType;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setBalanceFCY(BigDecimal balanceFCY) {
        this.balanceFCY = balanceFCY;
    }

    public void setBalanceLCY(BigDecimal balanceLCY) {
        this.balanceLCY = balanceLCY;
    }

    public void setOriginalCurrencyIdFCY(String originalCurrencyIdFCY) {
        this.originalCurrencyIdFCY = originalCurrencyIdFCY;
    }

    public void setOriginalCurrencyIdLCY(String originalCurrencyIdLCY) {
        this.originalCurrencyIdLCY = originalCurrencyIdLCY;
    }

    public void setBalanceType(OperationType balanceType) {
        this.balanceType = balanceType;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public void setDate(LocalDate date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpeningBalance)) {
            return false;
        }
        OpeningBalance other = (OpeningBalance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$balanceFCY = this.getBalanceFCY();
        BigDecimal other$balanceFCY = other.getBalanceFCY();
        if (this$balanceFCY == null ? other$balanceFCY != null : !((Object)this$balanceFCY).equals(other$balanceFCY)) {
            return false;
        }
        BigDecimal this$balanceLCY = this.getBalanceLCY();
        BigDecimal other$balanceLCY = other.getBalanceLCY();
        if (this$balanceLCY == null ? other$balanceLCY != null : !((Object)this$balanceLCY).equals(other$balanceLCY)) {
            return false;
        }
        String this$originalCurrencyIdFCY = this.getOriginalCurrencyIdFCY();
        String other$originalCurrencyIdFCY = other.getOriginalCurrencyIdFCY();
        if (this$originalCurrencyIdFCY == null ? other$originalCurrencyIdFCY != null : !this$originalCurrencyIdFCY.equals(other$originalCurrencyIdFCY)) {
            return false;
        }
        String this$originalCurrencyIdLCY = this.getOriginalCurrencyIdLCY();
        String other$originalCurrencyIdLCY = other.getOriginalCurrencyIdLCY();
        if (this$originalCurrencyIdLCY == null ? other$originalCurrencyIdLCY != null : !this$originalCurrencyIdLCY.equals(other$originalCurrencyIdLCY)) {
            return false;
        }
        OperationType this$balanceType = this.getBalanceType();
        OperationType other$balanceType = other.getBalanceType();
        if (this$balanceType == null ? other$balanceType != null : !((Object)((Object)this$balanceType)).equals((Object)other$balanceType)) {
            return false;
        }
        LocalDate this$date = this.getDate();
        LocalDate other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpeningBalance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $balanceFCY = this.getBalanceFCY();
        result = result * 59 + ($balanceFCY == null ? 43 : ((Object)$balanceFCY).hashCode());
        BigDecimal $balanceLCY = this.getBalanceLCY();
        result = result * 59 + ($balanceLCY == null ? 43 : ((Object)$balanceLCY).hashCode());
        String $originalCurrencyIdFCY = this.getOriginalCurrencyIdFCY();
        result = result * 59 + ($originalCurrencyIdFCY == null ? 43 : $originalCurrencyIdFCY.hashCode());
        String $originalCurrencyIdLCY = this.getOriginalCurrencyIdLCY();
        result = result * 59 + ($originalCurrencyIdLCY == null ? 43 : $originalCurrencyIdLCY.hashCode());
        OperationType $balanceType = this.getBalanceType();
        result = result * 59 + ($balanceType == null ? 43 : ((Object)((Object)$balanceType)).hashCode());
        LocalDate $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    public static class OpeningBalanceBuilder {
        private BigDecimal balanceFCY;
        private BigDecimal balanceLCY;
        private String originalCurrencyIdFCY;
        private String originalCurrencyIdLCY;
        private OperationType balanceType;
        private LocalDate date;

        OpeningBalanceBuilder() {
        }

        public OpeningBalanceBuilder balanceFCY(BigDecimal balanceFCY) {
            this.balanceFCY = balanceFCY;
            return this;
        }

        public OpeningBalanceBuilder balanceLCY(BigDecimal balanceLCY) {
            this.balanceLCY = balanceLCY;
            return this;
        }

        public OpeningBalanceBuilder originalCurrencyIdFCY(String originalCurrencyIdFCY) {
            this.originalCurrencyIdFCY = originalCurrencyIdFCY;
            return this;
        }

        public OpeningBalanceBuilder originalCurrencyIdLCY(String originalCurrencyIdLCY) {
            this.originalCurrencyIdLCY = originalCurrencyIdLCY;
            return this;
        }

        public OpeningBalanceBuilder balanceType(OperationType balanceType) {
            this.balanceType = balanceType;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        public OpeningBalanceBuilder date(LocalDate date) {
            this.date = date;
            return this;
        }

        public OpeningBalance build() {
            return new OpeningBalance(this.balanceFCY, this.balanceLCY, this.originalCurrencyIdFCY, this.originalCurrencyIdLCY, this.balanceType, this.date);
        }

        public String toString() {
            return "OpeningBalance.OpeningBalanceBuilder(balanceFCY=" + String.valueOf(this.balanceFCY) + ", balanceLCY=" + String.valueOf(this.balanceLCY) + ", originalCurrencyIdFCY=" + this.originalCurrencyIdFCY + ", originalCurrencyIdLCY=" + this.originalCurrencyIdLCY + ", balanceType=" + String.valueOf((Object)this.balanceType) + ", date=" + String.valueOf(this.date) + ")";
        }
    }
}

