/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Table;
import lombok.NonNull;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.envers.Audited;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_currency")
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class Currency
extends CommonEntity
implements Persistable<Id> {
    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="organisationId", column=@Column(name="organisation_id")), @AttributeOverride(name="customerCode", column=@Column(name="customer_code"))})
    @NonNull
    private Id id;
    @Column(name="currency_id", nullable=false)
    private String currencyId;

    public Currency(@NonNull Id id, String currencyId) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
        this.currencyId = currencyId;
    }

    public Currency() {
    }

    @NonNull
    public Id getId() {
        return this.id;
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public void setId(@NonNull Id id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    @Embeddable
    @Audited
    public static class Id {
        private String organisationId;
        private String customerCode;

        public Id(String organisationId, String customerCode) {
            this.organisationId = organisationId;
            this.customerCode = customerCode;
        }

        public Id() {
        }

        public String getOrganisationId() {
            return this.organisationId;
        }

        public String getCustomerCode() {
            return this.customerCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$organisationId = this.getOrganisationId();
            String other$organisationId = other.getOrganisationId();
            if (this$organisationId == null ? other$organisationId != null : !this$organisationId.equals(other$organisationId)) {
                return false;
            }
            String this$customerCode = this.getCustomerCode();
            String other$customerCode = other.getCustomerCode();
            return !(this$customerCode == null ? other$customerCode != null : !this$customerCode.equals(other$customerCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Id;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $organisationId = this.getOrganisationId();
            result = result * 59 + ($organisationId == null ? 43 : $organisationId.hashCode());
            String $customerCode = this.getCustomerCode();
            result = result * 59 + ($customerCode == null ? 43 : $customerCode.hashCode());
            return result;
        }
    }
}

