/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation;

import java.util.List;
import java.util.Optional;
import org.cardanofoundation.lob.app.organisation.OrganisationPublicApiIF;
import org.cardanofoundation.lob.app.organisation.domain.entity.AccountEvent;
import org.cardanofoundation.lob.app.organisation.domain.entity.ChartOfAccount;
import org.cardanofoundation.lob.app.organisation.domain.entity.CostCenter;
import org.cardanofoundation.lob.app.organisation.domain.entity.Currency;
import org.cardanofoundation.lob.app.organisation.domain.entity.Organisation;
import org.cardanofoundation.lob.app.organisation.domain.entity.Project;
import org.cardanofoundation.lob.app.organisation.domain.entity.Vat;
import org.cardanofoundation.lob.app.organisation.service.AccountEventService;
import org.cardanofoundation.lob.app.organisation.service.ChartOfAccountsService;
import org.cardanofoundation.lob.app.organisation.service.CostCenterService;
import org.cardanofoundation.lob.app.organisation.service.CurrencyService;
import org.cardanofoundation.lob.app.organisation.service.OrganisationService;
import org.cardanofoundation.lob.app.organisation.service.ProjectCodeService;
import org.cardanofoundation.lob.app.organisation.service.VatService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrganisationPublicApi
implements OrganisationPublicApiIF {
    private static final Logger log = LoggerFactory.getLogger(OrganisationPublicApi.class);
    private final OrganisationService organisationService;
    private final CurrencyService currencyService;
    private final VatService vatService;
    private final CostCenterService costCenterService;
    private final ProjectCodeService projectCodeService;
    private final ChartOfAccountsService chartOfAccountsService;
    private final AccountEventService accountEventService;

    @Override
    public List<Organisation> listAll() {
        return this.organisationService.findAll();
    }

    @Override
    public Optional<Organisation> findByOrganisationId(String id) {
        return this.organisationService.findById(id);
    }

    @Override
    public Optional<Currency> findCurrencyByCustomerCurrencyCode(String organisationId, String customerCurrencyCode) {
        return this.currencyService.findByOrganisationIdAndCode(organisationId, customerCurrencyCode);
    }

    @Override
    public Optional<Vat> findOrganisationByVatAndCode(String organisationId, String customerCode) {
        return this.vatService.findByOrganisationAndCode(organisationId, customerCode);
    }

    @Override
    public Optional<CostCenter> findCostCenter(String organisationId, String customerCode) {
        return this.costCenterService.getCostCenter(organisationId, customerCode);
    }

    @Override
    public Optional<Project> findProject(String organisationId, String customerCode) {
        return this.projectCodeService.getProject(organisationId, customerCode);
    }

    @Override
    public Optional<ChartOfAccount> getChartOfAccounts(String organisationId, String customerCode) {
        return this.chartOfAccountsService.getChartAccount(organisationId, customerCode);
    }

    @Override
    public Optional<AccountEvent> findEventCode(String organisationId, String debitcustomerCode, String creditCustomerCode) {
        return this.accountEventService.findByIdAndActive(organisationId, debitcustomerCode, creditCustomerCode);
    }

    public OrganisationPublicApi(OrganisationService organisationService, CurrencyService currencyService, VatService vatService, CostCenterService costCenterService, ProjectCodeService projectCodeService, ChartOfAccountsService chartOfAccountsService, AccountEventService accountEventService) {
        this.organisationService = organisationService;
        this.currencyService = currencyService;
        this.vatService = vatService;
        this.costCenterService = costCenterService;
        this.projectCodeService = projectCodeService;
        this.chartOfAccountsService = chartOfAccountsService;
        this.accountEventService = accountEventService;
    }
}

