/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.core.OrganisationViolation;
import org.cardanofoundation.lob.app.organisation.domain.entity.AccountEvent;
import org.cardanofoundation.lob.app.organisation.domain.entity.Organisation;
import org.cardanofoundation.lob.app.organisation.domain.request.OrganisationCreate;
import org.cardanofoundation.lob.app.organisation.domain.request.OrganisationUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.CostCenterView;
import org.cardanofoundation.lob.app.organisation.domain.view.OrganisationView;
import org.cardanofoundation.lob.app.organisation.domain.view.ProjectView;
import org.cardanofoundation.lob.app.organisation.domain.view.ValidationView;
import org.cardanofoundation.lob.app.organisation.repository.AccountEventRepository;
import org.cardanofoundation.lob.app.organisation.repository.OrganisationRepository;
import org.cardanofoundation.lob.app.organisation.service.CostCenterService;
import org.cardanofoundation.lob.app.organisation.service.CurrencyService;
import org.cardanofoundation.lob.app.organisation.service.ProjectCodeService;
import org.cardanofoundation.lob.app.organisation.service.validation.OrganisationValidationRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class OrganisationService {
    private static final Logger log = LoggerFactory.getLogger(OrganisationService.class);
    private final OrganisationRepository organisationRepository;
    private final AccountEventRepository accountEventRepository;
    private final CurrencyService currencyService;
    private final List<OrganisationValidationRule> validationRules;
    private final CostCenterService costCenterService;
    private final ProjectCodeService projectService;

    public Optional<Organisation> findById(String organisationId) {
        return this.organisationRepository.findById(organisationId);
    }

    public List<Organisation> findAll() {
        return this.organisationRepository.findAll();
    }

    public Set<AccountEvent> getOrganisationEventCode(String orgId) {
        return this.accountEventRepository.findAllByOrganisationId(orgId);
    }

    @Transactional
    public Optional<Organisation> createOrganisation(OrganisationCreate organisationCreate) {
        Organisation organisationO = new Organisation();
        organisationO.setId(Organisation.id(organisationCreate.getCountryCode(), organisationCreate.getTaxIdNumber()));
        organisationO.setCountryCode(organisationCreate.getCountryCode());
        organisationO.setTaxIdNumber(organisationCreate.getTaxIdNumber());
        organisationO.setDummyAccount("0000000000");
        organisationO.setAccountPeriodDays(7305);
        Organisation organisation = OrganisationService.getOrganisation(organisationCreate, organisationO);
        this.organisationRepository.saveAndFlush((Object)organisation);
        return Optional.of(organisation);
    }

    @Transactional
    public Optional<Organisation> updateOrganisation(Organisation organisationO, OrganisationUpdate organisationUpdate) {
        if (organisationUpdate.getName() != null) {
            organisationO.setName(organisationUpdate.getName());
        }
        if (organisationUpdate.getCity() != null) {
            organisationO.setCity(organisationUpdate.getCity());
        }
        if (organisationUpdate.getPostCode() != null) {
            organisationO.setPostCode(organisationUpdate.getPostCode());
        }
        if (organisationUpdate.getProvince() != null) {
            organisationO.setProvince(organisationUpdate.getProvince());
        }
        if (organisationUpdate.getAddress() != null) {
            organisationO.setAddress(organisationUpdate.getAddress());
        }
        if (organisationUpdate.getPhoneNumber() != null) {
            organisationO.setPhoneNumber(organisationUpdate.getPhoneNumber());
        }
        if (organisationUpdate.getAdminEmail() != null) {
            organisationO.setAdminEmail(organisationUpdate.getAdminEmail());
        }
        if (organisationUpdate.getWebsiteUrl() != null) {
            organisationO.setWebsiteUrl(organisationUpdate.getWebsiteUrl());
        }
        if (organisationUpdate.getCurrencyId() != null) {
            organisationO.setCurrencyId(organisationUpdate.getCurrencyId());
        }
        if (organisationUpdate.getReportCurrencyId() != null) {
            organisationO.setReportCurrencyId(organisationUpdate.getReportCurrencyId());
        }
        Organisation organisation = (Organisation)((Object)this.organisationRepository.saveAndFlush((Object)organisationO));
        return Optional.of(organisation);
    }

    public OrganisationView getOrganisationView(Organisation organisation) {
        LocalDate today = LocalDate.now();
        LocalDate monthsAgo = today.minusDays(organisation.getAccountPeriodDays());
        LocalDate yesterday = today.minusDays(1L);
        return new OrganisationView(organisation.getId(), organisation.getName(), organisation.getTaxIdNumber(), organisation.getCurrencyId(), organisation.getReportCurrencyId(), monthsAgo, yesterday, organisation.getAdminEmail(), organisation.getPhoneNumber(), organisation.getAddress(), organisation.getCity(), organisation.getPostCode(), organisation.getProvince(), organisation.getCountryCode(), this.costCenterService.getAllCostCenter(organisation.getId()).stream().map(CostCenterView::fromEntity).collect(Collectors.toSet()), this.projectService.getAllProjects(organisation.getId()).stream().map(ProjectView::fromEntity).collect(Collectors.toSet()), this.currencyService.findAllByOrganisationId(organisation.getId()).stream().map(organisationCurrency -> organisationCurrency.getId() != null ? organisationCurrency.getId().getCustomerCode() : null).collect(Collectors.toSet()), organisation.getWebsiteUrl(), organisation.getLogo());
    }

    private static Organisation getOrganisation(OrganisationCreate organisationCreate, Organisation organisation) {
        organisation.setName(organisationCreate.getName());
        organisation.setCity(organisationCreate.getCity());
        organisation.setPostCode(organisationCreate.getPostCode());
        organisation.setProvince(organisationCreate.getProvince());
        organisation.setAddress(organisationCreate.getAddress());
        organisation.setPhoneNumber(organisationCreate.getPhoneNumber());
        organisation.setAdminEmail(organisationCreate.getAdminEmail());
        organisation.setWebsiteUrl(organisationCreate.getWebsiteUrl());
        organisation.setCurrencyId(organisationCreate.getCurrencyId());
        organisation.setReportCurrencyId(organisationCreate.getReportCurrencyId());
        return organisation;
    }

    public ValidationView validateOrganisation(Organisation organisation) {
        ArrayList<OrganisationViolation> violations = new ArrayList<OrganisationViolation>();
        this.validationRules.forEach(rule -> rule.validate(organisation).ifPresent(violations::addAll));
        return ValidationView.builder().organisationId(organisation.getId()).violations(violations).isValid(violations.isEmpty()).build();
    }

    public OrganisationService(OrganisationRepository organisationRepository, AccountEventRepository accountEventRepository, CurrencyService currencyService, List<OrganisationValidationRule> validationRules, CostCenterService costCenterService, ProjectCodeService projectService) {
        this.organisationRepository = organisationRepository;
        this.accountEventRepository = accountEventRepository;
        this.currencyService = currencyService;
        this.validationRules = validationRules;
        this.costCenterService = costCenterService;
        this.projectService = projectService;
    }
}

