/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service;

import io.vavr.control.Either;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.csv.CostCenterUpdate;
import org.cardanofoundation.lob.app.organisation.domain.entity.CostCenter;
import org.cardanofoundation.lob.app.organisation.domain.view.CostCenterView;
import org.cardanofoundation.lob.app.organisation.repository.CostCenterRepository;
import org.cardanofoundation.lob.app.organisation.service.csv.CsvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

@Service
@Transactional(readOnly=true)
public class CostCenterService {
    private static final Logger log = LoggerFactory.getLogger(CostCenterService.class);
    private final CostCenterRepository costCenterRepository;
    private final CsvParser<CostCenterUpdate> csvParser;
    private final Validator validator;

    public Optional<CostCenter> getCostCenter(String organisationId, String customerCode) {
        return this.costCenterRepository.findByIdAndActive(new CostCenter.Id(organisationId, customerCode), true);
    }

    public Set<CostCenter> getAllCostCenter(String organisationId) {
        return this.costCenterRepository.findAllByOrganisationIdWithParentAndChildren(organisationId);
    }

    @Transactional
    public CostCenterView updateCostCenter(String orgId, CostCenterUpdate costCenterUpdate) {
        Optional costCenterFound = this.costCenterRepository.findById(new CostCenter.Id(orgId, costCenterUpdate.getCustomerCode()));
        if (costCenterFound.isPresent()) {
            Optional costCenterOptional;
            CostCenter costCenter = (CostCenter)((Object)costCenterFound.get());
            costCenter.setName(costCenterUpdate.getName());
            if (costCenterUpdate.getParentCustomerCode() != null && !costCenterUpdate.getParentCustomerCode().isBlank() && (costCenterOptional = this.costCenterRepository.findById(new CostCenter.Id(orgId, costCenterUpdate.getParentCustomerCode()))).isEmpty()) {
                return CostCenterView.createFail(costCenterUpdate, (Problem)Problem.builder().withStatus((StatusType)Status.NOT_FOUND).withTitle("PARENT_COST_CENTER_CODE_NOT_FOUND").withDetail("Parent project code with customer code %s not found.".formatted(costCenterUpdate.getParentCustomerCode())).build());
            }
            costCenter.setParentCustomerCode(costCenterUpdate.getParentCustomerCode() == null || costCenterUpdate.getParentCustomerCode().isBlank() ? null : costCenterUpdate.getParentCustomerCode());
            costCenter.setActive(costCenterUpdate.isActive());
            return CostCenterView.fromEntity((CostCenter)((Object)this.costCenterRepository.save((Object)costCenter)));
        }
        return CostCenterView.createFail(costCenterUpdate, (Problem)Problem.builder().withStatus((StatusType)Status.NOT_FOUND).withTitle("COST_CENTER_CODE_NOT_FOUND").withDetail("Cost Center with customer code %s not found.".formatted(costCenterUpdate.getCustomerCode())).build());
    }

    @Transactional
    public CostCenterView insertCostCenter(String orgId, CostCenterUpdate costCenterUpdate, boolean isUpsert) {
        Optional parent;
        Optional costCenterFound = this.costCenterRepository.findById(new CostCenter.Id(orgId, costCenterUpdate.getCustomerCode()));
        CostCenter costCenter = new CostCenter();
        costCenter.setId(new CostCenter.Id(orgId, costCenterUpdate.getCustomerCode()));
        if (costCenterFound.isPresent()) {
            if (!isUpsert) {
                return CostCenterView.createFail(costCenterUpdate, (Problem)Problem.builder().withStatus((StatusType)Status.CONFLICT).withTitle("COST_CENTER_CODE_ALREADY_EXISTS").withDetail("Cost Center with customer code %s already exists.".formatted(costCenterUpdate.getCustomerCode())).build());
            }
            costCenter = (CostCenter)((Object)costCenterFound.get());
        }
        costCenter.setName(costCenterUpdate.getName());
        costCenter.setActive(costCenterUpdate.isActive());
        if (costCenterUpdate.getParentCustomerCode() != null && !costCenterUpdate.getParentCustomerCode().isBlank() && (parent = this.costCenterRepository.findById(new CostCenter.Id(orgId, costCenterUpdate.getParentCustomerCode()))).isEmpty()) {
            return CostCenterView.createFail(costCenterUpdate, (Problem)Problem.builder().withTitle("PARENT_COST_CENTER_CODE_NOT_FOUND").withDetail("Parent project code with customer code %s not found.".formatted(costCenterUpdate.getParentCustomerCode())).build());
        }
        costCenter.setParentCustomerCode(costCenterUpdate.getParentCustomerCode() == null || costCenterUpdate.getParentCustomerCode().isBlank() ? null : costCenterUpdate.getParentCustomerCode());
        return CostCenterView.fromEntity((CostCenter)((Object)this.costCenterRepository.save((Object)costCenter)));
    }

    @Transactional
    public Either<Problem, List<CostCenterView>> createCostCenterFromCsv(String orgId, MultipartFile file) {
        return (Either)this.csvParser.parseCsv(file, CostCenterUpdate.class).fold(Either::left, costCenterUpdates -> Either.right(costCenterUpdates.stream().map(costCenterUpdate -> {
            Errors errors = this.validator.validateObject(costCenterUpdate);
            List allErrors = errors.getAllErrors();
            if (!allErrors.isEmpty()) {
                return CostCenterView.createFail(costCenterUpdate, (Problem)Problem.builder().withTitle("VALIDATION_ERROR").withDetail(allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "))).withStatus((StatusType)Status.BAD_REQUEST).build());
            }
            return this.insertCostCenter(orgId, (CostCenterUpdate)costCenterUpdate, true);
        }).toList()));
    }

    public CostCenterService(CostCenterRepository costCenterRepository, CsvParser<CostCenterUpdate> csvParser, Validator validator) {
        this.costCenterRepository = costCenterRepository;
        this.csvParser = csvParser;
        this.validator = validator;
    }
}

