/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.service;

import io.vavr.control.Either;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.organisation.domain.entity.AccountEvent;
import org.cardanofoundation.lob.app.organisation.domain.entity.Organisation;
import org.cardanofoundation.lob.app.organisation.domain.entity.ReferenceCode;
import org.cardanofoundation.lob.app.organisation.domain.request.EventCodeUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.AccountEventView;
import org.cardanofoundation.lob.app.organisation.repository.AccountEventRepository;
import org.cardanofoundation.lob.app.organisation.repository.ReferenceCodeRepository;
import org.cardanofoundation.lob.app.organisation.service.OrganisationService;
import org.cardanofoundation.lob.app.organisation.service.csv.CsvParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

@Service
@Transactional(readOnly=true)
public class AccountEventService {
    private static final Logger log = LoggerFactory.getLogger(AccountEventService.class);
    private final AccountEventRepository accountEventRepository;
    private final ReferenceCodeRepository referenceCodeRepository;
    private final OrganisationService organisationService;
    private final CsvParser<EventCodeUpdate> csvParser;
    private final Validator validator;

    public Optional<AccountEvent> findByIdAndActive(String organisationId, String debitReferenceCode, String creditReferenceCode) {
        return this.accountEventRepository.findByIdAndActive(new AccountEvent.Id(organisationId, debitReferenceCode, creditReferenceCode), true);
    }

    public List<AccountEventView> getAllAccountEvent(String orgId) {
        return this.accountEventRepository.findAllByOrganisationId(orgId).stream().map(AccountEventView::convertFromEntity).toList();
    }

    @Transactional
    public AccountEventView insertAccountEvent(String orgId, EventCodeUpdate eventCodeUpdate, boolean isUpsert) {
        Optional<Organisation> organisationChe = this.organisationService.findById(orgId);
        if (organisationChe.isEmpty()) {
            return AccountEventView.createFail((Problem)Problem.builder().withTitle("ORGANISATION_NOT_FOUND").withDetail("Unable to find Organisation by Id: %s".formatted(orgId)).withStatus((StatusType)Status.NOT_FOUND).build(), eventCodeUpdate);
        }
        Optional<ReferenceCode> debitReference = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, eventCodeUpdate.getDebitReferenceCode());
        if (debitReference.isEmpty()) {
            return AccountEventView.createFail((Problem)Problem.builder().withTitle("REFERENCE_CODE_NOT_FOUND").withDetail("Unable to find reference code by Id: %s:%s".formatted(eventCodeUpdate.getDebitReferenceCode(), eventCodeUpdate.getCreditReferenceCode())).withStatus((StatusType)Status.NOT_FOUND).build(), eventCodeUpdate);
        }
        Optional<ReferenceCode> creditReference = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, eventCodeUpdate.getCreditReferenceCode());
        if (creditReference.isEmpty()) {
            return AccountEventView.createFail((Problem)Problem.builder().withTitle("REFERENCE_CODE_NOT_FOUND").withDetail("Unable to find reference code by Id: %s:%s".formatted(eventCodeUpdate.getDebitReferenceCode(), eventCodeUpdate.getCreditReferenceCode())).withStatus((StatusType)Status.NOT_FOUND).build(), eventCodeUpdate);
        }
        ReferenceCode debitReferenceG = debitReference.get();
        ReferenceCode creditReferenceG = creditReference.get();
        Optional<AccountEvent> accountEventOpt = this.accountEventRepository.findByOrgIdAndDebitReferenceCodeAndCreditReferenceCode(orgId, eventCodeUpdate.getDebitReferenceCode(), eventCodeUpdate.getCreditReferenceCode());
        if (accountEventOpt.isPresent() && !isUpsert) {
            return AccountEventView.createFail((Problem)Problem.builder().withTitle("ACCOUNT_EVENT_ALREADY_EXISTS").withDetail("Account event already exists for debit reference code: %s and credit reference code: %s".formatted(eventCodeUpdate.getDebitReferenceCode(), eventCodeUpdate.getCreditReferenceCode())).withStatus((StatusType)Status.CONFLICT).build(), eventCodeUpdate);
        }
        AccountEvent accountEvent = AccountEvent.builder().id(new AccountEvent.Id(orgId, Objects.requireNonNull(debitReferenceG.getId()).getReferenceCode(), creditReferenceG.getId().getReferenceCode())).customerCode(debitReferenceG.getId().getReferenceCode() + creditReferenceG.getId().getReferenceCode()).build();
        accountEvent.setName(eventCodeUpdate.getName());
        accountEvent.setActive(this.isActive(debitReference.get(), creditReference.get()));
        return AccountEventView.convertFromEntity((AccountEvent)this.accountEventRepository.save(accountEvent));
    }

    @Transactional
    public AccountEventView updateAccountEvent(String orgId, EventCodeUpdate eventCodeUpdate) {
        Optional<Organisation> organisationChe = this.organisationService.findById(orgId);
        if (organisationChe.isEmpty()) {
            return AccountEventView.createFail((Problem)Problem.builder().withTitle("ORGANISATION_NOT_FOUND").withDetail("Unable to find Organisation by Id: %s".formatted(orgId)).withStatus((StatusType)Status.NOT_FOUND).build(), eventCodeUpdate);
        }
        Optional<ReferenceCode> debitReference = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, eventCodeUpdate.getDebitReferenceCode());
        if (debitReference.isEmpty()) {
            return AccountEventView.createFail((Problem)Problem.builder().withTitle("REFERENCE_CODE_NOT_FOUND").withDetail("Unable to find reference code by Id: %s and %s:%s".formatted(orgId, eventCodeUpdate.getDebitReferenceCode(), eventCodeUpdate.getCreditReferenceCode())).withStatus((StatusType)Status.NOT_FOUND).build(), eventCodeUpdate);
        }
        Optional<ReferenceCode> creditReference = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, eventCodeUpdate.getCreditReferenceCode());
        if (creditReference.isEmpty()) {
            return AccountEventView.createFail((Problem)Problem.builder().withTitle("REFERENCE_CODE_NOT_FOUND").withDetail("Unable to find reference code by Id: %s and %s:%s".formatted(orgId, eventCodeUpdate.getDebitReferenceCode(), eventCodeUpdate.getCreditReferenceCode())).withStatus((StatusType)Status.NOT_FOUND).build(), eventCodeUpdate);
        }
        Optional<AccountEvent> accountEventOpt = this.accountEventRepository.findByOrgIdAndDebitReferenceCodeAndCreditReferenceCode(orgId, eventCodeUpdate.getDebitReferenceCode(), eventCodeUpdate.getCreditReferenceCode());
        if (accountEventOpt.isEmpty()) {
            return AccountEventView.createFail((Problem)Problem.builder().withTitle("ACCOUNT_EVENT_NOT_FOUND").withDetail("Account event not found for debit reference code: %s and credit reference code: %s".formatted(eventCodeUpdate.getDebitReferenceCode(), eventCodeUpdate.getCreditReferenceCode())).withStatus((StatusType)Status.NOT_FOUND).build(), eventCodeUpdate);
        }
        AccountEvent accountEvent = accountEventOpt.get();
        accountEvent.setName(eventCodeUpdate.getName());
        accountEvent.setActive(this.isActive(debitReference.get(), creditReference.get()));
        return AccountEventView.convertFromEntity((AccountEvent)this.accountEventRepository.save(accountEvent));
    }

    @Transactional
    public Either<Set<Problem>, Set<AccountEventView>> insertAccountEventByCsv(String orgId, MultipartFile file) {
        return (Either)this.csvParser.parseCsv(file, EventCodeUpdate.class).fold(problem -> Either.left(Set.of(problem)), eventCodeUpdates -> Either.right(eventCodeUpdates.stream().map(eventCodeUpdate -> {
            Errors errors = this.validator.validateObject(eventCodeUpdate);
            List allErrors = errors.getAllErrors();
            if (!allErrors.isEmpty()) {
                return AccountEventView.createFail((Problem)Problem.builder().withTitle("VALIDATION_ERROR").withDetail(allErrors.stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.joining(", "))).withStatus((StatusType)Status.BAD_REQUEST).build(), eventCodeUpdate);
            }
            return this.insertAccountEvent(orgId, (EventCodeUpdate)eventCodeUpdate, true);
        }).collect(Collectors.toSet())));
    }

    public void updateStatus(String orgId, String refCode) {
        this.accountEventRepository.findByOrgIdAndRefCodeAccount(orgId, refCode).forEach(accountEvent -> {
            ReferenceCode debitReference = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, accountEvent.getId().getDebitReferenceCode()).get();
            ReferenceCode creditReference = this.referenceCodeRepository.findByOrgIdAndReferenceCode(orgId, accountEvent.getId().getCreditReferenceCode()).get();
            accountEvent.setActive(this.isActive(debitReference, creditReference));
            this.accountEventRepository.save(accountEvent);
        });
    }

    public boolean isActive(ReferenceCode debitReference, ReferenceCode creditReference) {
        return debitReference.isActive() && creditReference.isActive();
    }

    public AccountEventService(AccountEventRepository accountEventRepository, ReferenceCodeRepository referenceCodeRepository, OrganisationService organisationService, CsvParser<EventCodeUpdate> csvParser, Validator validator) {
        this.accountEventRepository = accountEventRepository;
        this.referenceCodeRepository = referenceCodeRepository;
        this.organisationService = organisationService;
        this.csvParser = csvParser;
        this.validator = validator;
    }
}

