/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.resource;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.cardanofoundation.lob.app.organisation.domain.request.ReportTypeFieldUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.AccountEventView;
import org.cardanofoundation.lob.app.organisation.domain.view.ReportTypeView;
import org.cardanofoundation.lob.app.organisation.service.ReportTypeService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.zalando.problem.Problem;

@RestController
@RequestMapping(value={"/api/v1/organisations/report-types"})
@Tag(name="Organisation", description="Organisation API")
@CrossOrigin(origins={"http://localhost:3000"})
@ConditionalOnProperty(value={"lob.organisation.enabled"}, havingValue="true", matchIfMissing=true)
public class ReportTypeController {
    private final ReportTypeService reportTypeService;

    @Operation(description="Report Types", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=AccountEventView.class)))})})
    @GetMapping(value={"/{orgId}"}, produces={"application/json"})
    public ResponseEntity<List<ReportTypeView>> getReferenceCodes(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        return ResponseEntity.ok().body(this.reportTypeService.getAllReportTypes(orgId));
    }

    @Operation(description="Add mapping to Report Type field")
    @PostMapping(value={"/{orgId}/field-mappings"}, produces={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> addMappingToReportTypeField(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody ReportTypeFieldUpdate reportTypeFieldUpdate) {
        if (this.reportTypeService.addMappingToReportTypeField(orgId, reportTypeFieldUpdate).isLeft()) {
            Problem problem = (Problem)this.reportTypeService.addMappingToReportTypeField(orgId, reportTypeFieldUpdate).getLeft();
            ResponseEntity.status((int)Objects.requireNonNull(problem.getStatus()).getStatusCode()).body((Object)problem);
        }
        return ResponseEntity.ok().body((Object)true);
    }

    @Operation(description="Add mapping to Report Type field via CSV")
    @PostMapping(value={"/{orgId}/field-mappings"}, produces={"application/json"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAccountantRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> addMappingToReportTypeField(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @RequestParam(value="file") MultipartFile file) {
        if (this.reportTypeService.addMappingToReportTypeFieldCsv(orgId, file).isLeft()) {
            Set left = (Set)this.reportTypeService.addMappingToReportTypeFieldCsv(orgId, file).getLeft();
            return ResponseEntity.status((int)Objects.requireNonNull(400)).body((Object)left);
        }
        return ResponseEntity.ok().body((Object)true);
    }

    public ReportTypeController(ReportTypeService reportTypeService) {
        this.reportTypeService = reportTypeService;
    }
}

