/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.resource;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cardanofoundation.lob.app.organisation.domain.entity.Organisation;
import org.cardanofoundation.lob.app.organisation.domain.request.OrganisationCreate;
import org.cardanofoundation.lob.app.organisation.domain.request.OrganisationUpdate;
import org.cardanofoundation.lob.app.organisation.domain.view.EventView;
import org.cardanofoundation.lob.app.organisation.domain.view.OrganisationView;
import org.cardanofoundation.lob.app.organisation.domain.view.ValidationView;
import org.cardanofoundation.lob.app.organisation.service.OrganisationService;
import org.cardanofoundation.lob.app.support.security.KeycloakSecurityHelper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

@RestController
@RequestMapping(value={"/api/v1"})
@Tag(name="Organisation", description="Organisation API")
@CrossOrigin(origins={"http://localhost:3000"})
@ConditionalOnProperty(value={"lob.organisation.enabled"}, havingValue="true", matchIfMissing=true)
public class OrganisationResource {
    private final OrganisationService organisationService;
    private final KeycloakSecurityHelper keycloakSecurityHelper;

    @Operation(description="Organisations", parameters={@Parameter(name="orgIds", description="Optional list of organisation IDs", in=ParameterIn.QUERY, array=@ArraySchema(schema=@Schema(type="string")))}, responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=OrganisationView.class)))})})
    @GetMapping(value={"/organisations"}, produces={"application/json"})
    public ResponseEntity<List<OrganisationView>> organisationList(@RequestParam(value="orgIds", required=false) Optional<String[]> orgIds) {
        return ResponseEntity.ok().body(orgIds.map(orgs -> Arrays.stream(orgs).map(this.organisationService::findById).filter(Optional::isPresent).map(Optional::get).map(this.organisationService::getOrganisationView).toList()).orElse(this.organisationService.findAll().stream().map(this.organisationService::getOrganisationView).toList()));
    }

    @Operation(description="Transaction types", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=OrganisationView.class))}), @ApiResponse(responseCode="404", description="Error: response status is 404", content={@Content(mediaType="application/json", schema=@Schema(example="{\n\"title\": \"Organisation not found\",\n\"status\": 404,\n\"detail\": \"Unable to get the organisation\"\n}\n"))})})
    @GetMapping(value={"/organisations/{orgId}"}, produces={"application/json"})
    public ResponseEntity<?> organisationDetailSpecific(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        Optional<OrganisationView> organisation = this.organisationService.findById(orgId).map(this.organisationService::getOrganisationView);
        if (organisation.isEmpty()) {
            ThrowableProblem issue = Problem.builder().withTitle("ORGANISATION_NOT_FOUND").withDetail("Unable to find Organisation by Id: %s".formatted(orgId)).withStatus((StatusType)Status.NOT_FOUND).build();
            return ResponseEntity.status((int)issue.getStatus().getStatusCode()).body((Object)issue);
        }
        return ResponseEntity.ok().body(organisation);
    }

    @Operation(description="Organisation Events", responses={@ApiResponse(content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=EventView.class)))})})
    @GetMapping(value={"/organisations/{orgId}/events"}, produces={"application/json"})
    public ResponseEntity<List<EventView>> organisationEvent(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        return ResponseEntity.ok().body(this.organisationService.getOrganisationEventCode(orgId).stream().map(accountEvent -> new EventView(accountEvent.getCustomerCode(), accountEvent.getId().getOrganisationId(), accountEvent.getName())).toList());
    }

    @Operation(description="Organistion create", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=OrganisationView.class))}), @ApiResponse(responseCode="404", description="Error: response status is 404", content={@Content(mediaType="application/json", schema=@Schema(example="{\n\"title\": \"ORGANISATION_ALREADY_EXIST\",\n\"status\": 404,\n\"detail\": \"Unable to crate Organisation with IdNumber\"\n}\n"))})})
    @PostMapping(value={"/organisations"}, produces={"application/json"}, consumes={"application/json"})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAdminRole())")
    public ResponseEntity<?> organisationCreate(@Valid @RequestBody OrganisationCreate organisationCreate) {
        Optional<Organisation> organisationChe = this.organisationService.findById(Organisation.id(organisationCreate.getCountryCode(), organisationCreate.getTaxIdNumber()));
        if (organisationChe.isPresent()) {
            ThrowableProblem issue = Problem.builder().withTitle("ORGANISATION_ALREADY_EXIST").withDetail("Unable to crate Organisation with IdNumber: %s and CountryCode: %s".formatted(organisationCreate.getTaxIdNumber(), organisationCreate.getCountryCode())).withStatus((StatusType)Status.NOT_FOUND).build();
            return ResponseEntity.status((int)issue.getStatus().getStatusCode()).body((Object)issue);
        }
        Optional<OrganisationView> organisation = this.organisationService.createOrganisation(organisationCreate).map(this.organisationService::getOrganisationView);
        if (organisation.isEmpty()) {
            ThrowableProblem issue = Problem.builder().withTitle("ORGANISATION_CREATE_ERROR").withDetail("Unable to create Organisation by Id: %s".formatted(organisationCreate.getName())).withStatus((StatusType)Status.NOT_FOUND).build();
            return ResponseEntity.status((int)issue.getStatus().getStatusCode()).body((Object)issue);
        }
        return ResponseEntity.ok().body((Object)organisation.get());
    }

    @Operation(description="Organistion update", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=OrganisationView.class))}), @ApiResponse(responseCode="404", description="Error: response status is 404", content={@Content(mediaType="application/json", schema=@Schema(example="{\n\"title\": \"Organisation not found\",\n\"status\": 404,\n\"detail\": \"Unable to get the organisation\"\n}\n"))}), @ApiResponse(responseCode="404", description="Error: response status is 404", content={@Content(mediaType="application/json", schema=@Schema(example="{\n\"title\": \"ORGANISATION_UPDATE_ERROR\",\n\"status\": 404,\n\"detail\": \"Unable to create Organisation\"\n}\n"))})})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAdminRole())")
    @PutMapping(value={"/organisations/{orgId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<?> organisationUpdate(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId, @Valid @RequestBody OrganisationUpdate organisationUpdate) {
        Optional<Organisation> organisationChe = this.organisationService.findById(orgId);
        if (organisationChe.isEmpty()) {
            ThrowableProblem issue = Problem.builder().withTitle("ORGANISATION_NOT_FOUND").withDetail("Unable to find Organisation by Id: %s".formatted(orgId)).withStatus((StatusType)Status.NOT_FOUND).build();
            return ResponseEntity.status((int)issue.getStatus().getStatusCode()).body((Object)issue);
        }
        Optional<OrganisationView> organisation = this.organisationService.updateOrganisation(organisationChe.get(), organisationUpdate).map(this.organisationService::getOrganisationView);
        if (organisation.isEmpty()) {
            ThrowableProblem issue = Problem.builder().withTitle("ORGANISATION_UPDATE_ERROR").withDetail("Unable to create Organisation by Id: %s".formatted(organisationUpdate.getName())).withStatus((StatusType)Status.NOT_FOUND).build();
            return ResponseEntity.status((int)issue.getStatus().getStatusCode()).body((Object)issue);
        }
        return ResponseEntity.ok().body((Object)organisation.get());
    }

    @Operation(description="Organisation validation", responses={@ApiResponse(content={@Content(mediaType="application/json", schema=@Schema(implementation=ValidationView.class))}), @ApiResponse(responseCode="404", description="Error: response status is 404", content={@Content(mediaType="application/json", schema=@Schema(example="{\n\"title: \"Organisation not found\",\n\"status\": 404,\n\"detail\": \"Unable to find Organisation by Id\"\n}\n"))})})
    @PreAuthorize(value="hasRole(@securityConfig.getManagerRole()) or hasRole(@securityConfig.getAdminRole()) or hasRole(@securityConfig.getAccountantRole())")
    @GetMapping(value={"/organisations/{orgId}/validate"}, produces={"application/json"})
    public ResponseEntity<?> validateOrganisation(@PathVariable(value="orgId") @Parameter(example="75f95560c1d883ee7628993da5adf725a5d97a13929fd4f477be0faf5020ca94") String orgId) {
        if (this.keycloakSecurityHelper.canUserAccessOrg(orgId)) {
            Optional<Organisation> organisationOptional = this.organisationService.findById(orgId);
            if (organisationOptional.isEmpty()) {
                ThrowableProblem issue = Problem.builder().withTitle("ORGANISATION_NOT_FOUND").withDetail("Unable to find Organisation by Id: %s".formatted(orgId)).withStatus((StatusType)Status.NOT_FOUND).build();
                return ResponseEntity.status((int)Objects.requireNonNull(issue.getStatus()).getStatusCode()).body((Object)issue);
            }
            return ResponseEntity.ok((Object)this.organisationService.validateOrganisation(organisationOptional.get()));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatusCode.valueOf((int)403)).body((Object)"User is not allowed to access this organisation");
    }

    public OrganisationResource(OrganisationService organisationService, KeycloakSecurityHelper keycloakSecurityHelper) {
        this.organisationService = organisationService;
        this.keycloakSecurityHelper = keycloakSecurityHelper;
    }
}

