/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.view;

import java.math.BigDecimal;
import java.util.Optional;
import org.cardanofoundation.lob.app.organisation.domain.entity.Vat;
import org.cardanofoundation.lob.app.organisation.domain.request.VatUpdate;
import org.zalando.problem.Problem;

public class VatView {
    private String organisationId;
    private String customerCode;
    private String rate;
    private String countryCode;
    private String description;
    private Boolean active;
    private Problem error;

    public Optional<Problem> getError() {
        return Optional.ofNullable(this.error);
    }

    public static VatView convertFromEntity(Vat vat) {
        return VatView.builder().customerCode(vat.getId().getCustomerCode()).organisationId(vat.getId().getOrganisationId()).rate(vat.getRate().toString()).countryCode(vat.getCountryCode()).description(vat.getDescription()).active(vat.getActive()).build();
    }

    public static VatView createFail(VatUpdate vatUpdate, Problem error) {
        return VatView.builder().customerCode(vatUpdate.getCustomerCode()).rate(Optional.ofNullable(vatUpdate.getRate()).map(BigDecimal::toPlainString).orElse(null)).countryCode(vatUpdate.getCountryCode()).description(vatUpdate.getDescription()).active(vatUpdate.getActive()).error(error).build();
    }

    public static VatViewBuilder builder() {
        return new VatViewBuilder();
    }

    public String getOrganisationId() {
        return this.organisationId;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getRate() {
        return this.rate;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getActive() {
        return this.active;
    }

    public VatView(String organisationId, String customerCode, String rate, String countryCode, String description, Boolean active, Problem error) {
        this.organisationId = organisationId;
        this.customerCode = customerCode;
        this.rate = rate;
        this.countryCode = countryCode;
        this.description = description;
        this.active = active;
        this.error = error;
    }

    public static class VatViewBuilder {
        private String organisationId;
        private String customerCode;
        private String rate;
        private String countryCode;
        private String description;
        private Boolean active;
        private Problem error;

        VatViewBuilder() {
        }

        public VatViewBuilder organisationId(String organisationId) {
            this.organisationId = organisationId;
            return this;
        }

        public VatViewBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public VatViewBuilder rate(String rate) {
            this.rate = rate;
            return this;
        }

        public VatViewBuilder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public VatViewBuilder description(String description) {
            this.description = description;
            return this;
        }

        public VatViewBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public VatViewBuilder error(Problem error) {
            this.error = error;
            return this;
        }

        public VatView build() {
            return new VatView(this.organisationId, this.customerCode, this.rate, this.countryCode, this.description, this.active, this.error);
        }

        public String toString() {
            return "VatView.VatViewBuilder(organisationId=" + this.organisationId + ", customerCode=" + this.customerCode + ", rate=" + this.rate + ", countryCode=" + this.countryCode + ", description=" + this.description + ", active=" + this.active + ", error=" + String.valueOf(this.error) + ")";
        }
    }
}

