/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.request;

import com.opencsv.bean.CsvBindByName;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import javax.annotation.Nullable;
import org.cardanofoundation.lob.app.organisation.domain.entity.ReferenceCode;

public class ReferenceCodeUpdate {
    @Schema(example="0000")
    @CsvBindByName(column="Reference Code")
    @NotNull(message="Reference Code is required")
    private @NotNull(message="Reference Code is required") String referenceCode;
    @Schema(example="Example reference code")
    @CsvBindByName(column="Name")
    @NotNull(message="Name is required")
    private @NotNull(message="Name is required") String name;
    @Nullable
    @CsvBindByName(column="Parent Reference Code")
    private String parentReferenceCode;
    @Schema(example="true")
    @CsvBindByName(column="Active")
    private boolean isActive = true;

    public ReferenceCode toEntity(String orgId) {
        return ReferenceCode.builder().id(new ReferenceCode.Id(orgId, this.referenceCode)).name(this.name).isActive(this.isActive).parentReferenceCode(this.parentReferenceCode.isEmpty() ? null : this.parentReferenceCode).build();
    }

    public String getReferenceCode() {
        return this.referenceCode;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getParentReferenceCode() {
        return this.parentReferenceCode;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParentReferenceCode(@Nullable String parentReferenceCode) {
        this.parentReferenceCode = parentReferenceCode;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public ReferenceCodeUpdate(String referenceCode, String name, @Nullable String parentReferenceCode, boolean isActive) {
        this.referenceCode = referenceCode;
        this.name = name;
        this.parentReferenceCode = parentReferenceCode;
        this.isActive = isActive;
    }

    public ReferenceCodeUpdate() {
    }
}

