/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Optional;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_ref_codes")
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class ReferenceCode
extends CommonEntity
implements Persistable<Id> {
    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="organisationId", column=@Column(name="organisation_id")), @AttributeOverride(name="referenceCode", column=@Column(name="reference_code"))})
    private Id id;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="organisation_id", referencedColumnName="organisation_id", insertable=false, updatable=false), @JoinColumn(name="parent_reference_code", referencedColumnName="reference_code", insertable=false, updatable=false)})
    @NotAudited
    private ReferenceCode parent;
    @Column(name="parent_reference_code")
    private String parentReferenceCode;
    private String name;
    @Column(name="active")
    private boolean isActive;

    public Optional<ReferenceCode> getParent() {
        return Optional.ofNullable(this.parent);
    }

    private static boolean $default$isActive() {
        return true;
    }

    public static ReferenceCodeBuilder builder() {
        return new ReferenceCodeBuilder();
    }

    public ReferenceCode(Id id, ReferenceCode parent, String parentReferenceCode, String name, boolean isActive) {
        this.id = id;
        this.parent = parent;
        this.parentReferenceCode = parentReferenceCode;
        this.name = name;
        this.isActive = isActive;
    }

    public ReferenceCode() {
        this.isActive = ReferenceCode.$default$isActive();
    }

    public Id getId() {
        return this.id;
    }

    public String getParentReferenceCode() {
        return this.parentReferenceCode;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public void setParent(ReferenceCode parent) {
        this.parent = parent;
    }

    public void setParentReferenceCode(String parentReferenceCode) {
        this.parentReferenceCode = parentReferenceCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public static class ReferenceCodeBuilder {
        private Id id;
        private ReferenceCode parent;
        private String parentReferenceCode;
        private String name;
        private boolean isActive$set;
        private boolean isActive$value;

        ReferenceCodeBuilder() {
        }

        public ReferenceCodeBuilder id(Id id) {
            this.id = id;
            return this;
        }

        public ReferenceCodeBuilder parent(ReferenceCode parent) {
            this.parent = parent;
            return this;
        }

        public ReferenceCodeBuilder parentReferenceCode(String parentReferenceCode) {
            this.parentReferenceCode = parentReferenceCode;
            return this;
        }

        public ReferenceCodeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ReferenceCodeBuilder isActive(boolean isActive) {
            this.isActive$value = isActive;
            this.isActive$set = true;
            return this;
        }

        public ReferenceCode build() {
            boolean isActive$value = this.isActive$value;
            if (!this.isActive$set) {
                isActive$value = ReferenceCode.$default$isActive();
            }
            return new ReferenceCode(this.id, this.parent, this.parentReferenceCode, this.name, isActive$value);
        }

        public String toString() {
            return "ReferenceCode.ReferenceCodeBuilder(id=" + String.valueOf(this.id) + ", parent=" + String.valueOf((Object)this.parent) + ", parentReferenceCode=" + this.parentReferenceCode + ", name=" + this.name + ", isActive$value=" + this.isActive$value + ")";
        }
    }

    @Embeddable
    public static class Id {
        private String organisationId;
        private String referenceCode;

        public Id(String organisationId, String referenceCode) {
            this.organisationId = organisationId;
            this.referenceCode = referenceCode;
        }

        public Id() {
        }

        public String getOrganisationId() {
            return this.organisationId;
        }

        public String getReferenceCode() {
            return this.referenceCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$organisationId = this.getOrganisationId();
            String other$organisationId = other.getOrganisationId();
            if (this$organisationId == null ? other$organisationId != null : !this$organisationId.equals(other$organisationId)) {
                return false;
            }
            String this$referenceCode = this.getReferenceCode();
            String other$referenceCode = other.getReferenceCode();
            return !(this$referenceCode == null ? other$referenceCode != null : !this$referenceCode.equals(other$referenceCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Id;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $organisationId = this.getOrganisationId();
            result = result * 59 + ($organisationId == null ? 43 : $organisationId.hashCode());
            String $referenceCode = this.getReferenceCode();
            result = result * 59 + ($referenceCode == null ? 43 : $referenceCode.hashCode());
            return result;
        }
    }
}

