/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_cost_center")
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class CostCenter
extends CommonEntity
implements Persistable<Id> {
    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="organisationId", column=@Column(name="organisation_id")), @AttributeOverride(name="customerCode", column=@Column(name="customer_code"))})
    private Id id;
    @Column(name="name", nullable=false)
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="organisation_id", referencedColumnName="organisation_id", insertable=false, updatable=false), @JoinColumn(name="parent_customer_code", referencedColumnName="customer_code", insertable=false, updatable=false)})
    @NotAudited
    @JsonBackReference
    private CostCenter parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JsonManagedReference
    private Set<CostCenter> children;
    @Column(name="parent_customer_code")
    private String parentCustomerCode;
    @Column(name="active")
    private boolean active;

    public Optional<CostCenter> getParent() {
        return Optional.ofNullable(this.parent);
    }

    private static Set<CostCenter> $default$children() {
        return new HashSet<CostCenter>();
    }

    private static boolean $default$active() {
        return true;
    }

    public static CostCenterBuilder builder() {
        return new CostCenterBuilder();
    }

    public CostCenter(Id id, String name, CostCenter parent, Set<CostCenter> children, String parentCustomerCode, boolean active) {
        this.id = id;
        this.name = name;
        this.parent = parent;
        this.children = children;
        this.parentCustomerCode = parentCustomerCode;
        this.active = active;
    }

    public CostCenter() {
        this.children = CostCenter.$default$children();
        this.active = CostCenter.$default$active();
    }

    public Id getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Set<CostCenter> getChildren() {
        return this.children;
    }

    public String getParentCustomerCode() {
        return this.parentCustomerCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(CostCenter parent) {
        this.parent = parent;
    }

    public void setChildren(Set<CostCenter> children) {
        this.children = children;
    }

    public void setParentCustomerCode(String parentCustomerCode) {
        this.parentCustomerCode = parentCustomerCode;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static class CostCenterBuilder {
        private Id id;
        private String name;
        private CostCenter parent;
        private boolean children$set;
        private Set<CostCenter> children$value;
        private String parentCustomerCode;
        private boolean active$set;
        private boolean active$value;

        CostCenterBuilder() {
        }

        public CostCenterBuilder id(Id id) {
            this.id = id;
            return this;
        }

        public CostCenterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CostCenterBuilder parent(CostCenter parent) {
            this.parent = parent;
            return this;
        }

        public CostCenterBuilder children(Set<CostCenter> children) {
            this.children$value = children;
            this.children$set = true;
            return this;
        }

        public CostCenterBuilder parentCustomerCode(String parentCustomerCode) {
            this.parentCustomerCode = parentCustomerCode;
            return this;
        }

        public CostCenterBuilder active(boolean active) {
            this.active$value = active;
            this.active$set = true;
            return this;
        }

        public CostCenter build() {
            Set<CostCenter> children$value = this.children$value;
            if (!this.children$set) {
                children$value = CostCenter.$default$children();
            }
            boolean active$value = this.active$value;
            if (!this.active$set) {
                active$value = CostCenter.$default$active();
            }
            return new CostCenter(this.id, this.name, this.parent, children$value, this.parentCustomerCode, active$value);
        }

        public String toString() {
            return "CostCenter.CostCenterBuilder(id=" + String.valueOf(this.id) + ", name=" + this.name + ", parent=" + String.valueOf((Object)this.parent) + ", children$value=" + String.valueOf(this.children$value) + ", parentCustomerCode=" + this.parentCustomerCode + ", active$value=" + this.active$value + ")";
        }
    }

    @Embeddable
    public static class Id {
        private String organisationId;
        private String customerCode;

        public Id(String organisationId, String customerCode) {
            this.organisationId = organisationId;
            this.customerCode = customerCode;
        }

        public Id() {
        }

        public String getOrganisationId() {
            return this.organisationId;
        }

        public String getCustomerCode() {
            return this.customerCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id other = (Id)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$organisationId = this.getOrganisationId();
            String other$organisationId = other.getOrganisationId();
            if (this$organisationId == null ? other$organisationId != null : !this$organisationId.equals(other$organisationId)) {
                return false;
            }
            String this$customerCode = this.getCustomerCode();
            String other$customerCode = other.getCustomerCode();
            return !(this$customerCode == null ? other$customerCode != null : !this$customerCode.equals(other$customerCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Id;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $organisationId = this.getOrganisationId();
            result = result * 59 + ($organisationId == null ? 43 : $organisationId.hashCode());
            String $customerCode = this.getCustomerCode();
            result = result * 59 + ($customerCode == null ? 43 : $customerCode.hashCode());
            return result;
        }
    }
}

