/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.LinkedHashSet;
import java.util.Set;
import org.cardanofoundation.lob.app.organisation.domain.entity.ChartOfAccountSubType;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.envers.Audited;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_chart_of_account_type", indexes={@Index(name="atu_name", columnList="name", unique=true)})
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class ChartOfAccountType
extends CommonEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="organisation_id", nullable=false)
    private String organisationId;
    @Column(name="name", nullable=false)
    private String name;
    @OneToMany(mappedBy="type", orphanRemoval=true, fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<ChartOfAccountSubType> subTypes;

    private static Set<ChartOfAccountSubType> $default$subTypes() {
        return new LinkedHashSet<ChartOfAccountSubType>();
    }

    public static ChartOfAccountTypeBuilder builder() {
        return new ChartOfAccountTypeBuilder();
    }

    public ChartOfAccountType(Long id, String organisationId, String name, Set<ChartOfAccountSubType> subTypes) {
        this.id = id;
        this.organisationId = organisationId;
        this.name = name;
        this.subTypes = subTypes;
    }

    public ChartOfAccountType() {
        this.subTypes = ChartOfAccountType.$default$subTypes();
    }

    public Long getId() {
        return this.id;
    }

    public String getOrganisationId() {
        return this.organisationId;
    }

    public String getName() {
        return this.name;
    }

    public Set<ChartOfAccountSubType> getSubTypes() {
        return this.subTypes;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrganisationId(String organisationId) {
        this.organisationId = organisationId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubTypes(Set<ChartOfAccountSubType> subTypes) {
        this.subTypes = subTypes;
    }

    public static class ChartOfAccountTypeBuilder {
        private Long id;
        private String organisationId;
        private String name;
        private boolean subTypes$set;
        private Set<ChartOfAccountSubType> subTypes$value;

        ChartOfAccountTypeBuilder() {
        }

        public ChartOfAccountTypeBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ChartOfAccountTypeBuilder organisationId(String organisationId) {
            this.organisationId = organisationId;
            return this;
        }

        public ChartOfAccountTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChartOfAccountTypeBuilder subTypes(Set<ChartOfAccountSubType> subTypes) {
            this.subTypes$value = subTypes;
            this.subTypes$set = true;
            return this;
        }

        public ChartOfAccountType build() {
            Set<ChartOfAccountSubType> subTypes$value = this.subTypes$value;
            if (!this.subTypes$set) {
                subTypes$value = ChartOfAccountType.$default$subTypes();
            }
            return new ChartOfAccountType(this.id, this.organisationId, this.name, subTypes$value);
        }

        public String toString() {
            return "ChartOfAccountType.ChartOfAccountTypeBuilder(id=" + this.id + ", organisationId=" + this.organisationId + ", name=" + this.name + ", subTypes$value=" + String.valueOf(this.subTypes$value) + ")";
        }
    }
}

