/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.organisation.domain.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.cardanofoundation.lob.app.organisation.domain.entity.ChartOfAccountType;
import org.cardanofoundation.lob.app.support.spring_audit.CommonEntity;
import org.hibernate.envers.Audited;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="organisation_chart_of_account_sub_type", indexes={@Index(name="astu_name", columnList="name", unique=true)})
@Audited
@EntityListeners(value={AuditingEntityListener.class})
public class ChartOfAccountSubType
extends CommonEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="organisation_id", nullable=false)
    private String organisationId;
    @Column(name="name", nullable=false)
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="type", referencedColumnName="id")
    private ChartOfAccountType type;

    public static ChartOfAccountSubTypeBuilder builder() {
        return new ChartOfAccountSubTypeBuilder();
    }

    public ChartOfAccountSubType(Long id, String organisationId, String name, ChartOfAccountType type) {
        this.id = id;
        this.organisationId = organisationId;
        this.name = name;
        this.type = type;
    }

    public ChartOfAccountSubType() {
    }

    public Long getId() {
        return this.id;
    }

    public String getOrganisationId() {
        return this.organisationId;
    }

    public String getName() {
        return this.name;
    }

    public ChartOfAccountType getType() {
        return this.type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrganisationId(String organisationId) {
        this.organisationId = organisationId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(ChartOfAccountType type) {
        this.type = type;
    }

    public static class ChartOfAccountSubTypeBuilder {
        private Long id;
        private String organisationId;
        private String name;
        private ChartOfAccountType type;

        ChartOfAccountSubTypeBuilder() {
        }

        public ChartOfAccountSubTypeBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ChartOfAccountSubTypeBuilder organisationId(String organisationId) {
            this.organisationId = organisationId;
            return this;
        }

        public ChartOfAccountSubTypeBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChartOfAccountSubTypeBuilder type(ChartOfAccountType type) {
            this.type = type;
            return this;
        }

        public ChartOfAccountSubType build() {
            return new ChartOfAccountSubType(this.id, this.organisationId, this.name, this.type);
        }

        public String toString() {
            return "ChartOfAccountSubType.ChartOfAccountSubTypeBuilder(id=" + this.id + ", organisationId=" + this.organisationId + ", name=" + this.name + ", type=" + String.valueOf((Object)this.type) + ")";
        }
    }
}

