/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_reader.config;

import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.backend.blockfrost.service.BFBackendService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class YaciStoreConfig {
    private static final Logger log = LoggerFactory.getLogger(YaciStoreConfig.class);
    @Value(value="${lob.blockfrost.url:http://localhost:8080/api/v1/}")
    private String baseUrl;
    @Value(value="${lob.blockfrost.project_id:}")
    private String projectId;

    @Bean
    @Qualifier(value="yaci_blockfrost")
    @ConditionalOnProperty(name={"lob.blockchain_reader.enabled"}, havingValue="true")
    public BackendService yaciBackendService() {
        log.info("Creating Yaci Blockfrost backend service with baseUrl: {}", (Object)this.baseUrl);
        return new BFBackendService(this.baseUrl, this.projectId);
    }

    @Bean
    @Qualifier(value="yaci_blockfrost")
    @ConditionalOnProperty(name={"lob.blockchain_reader.enabled"}, havingValue="false")
    public BackendService coreBackendService(@Qualifier(value="original_blockfrost") BackendService blockfrostBackend) {
        log.info("Creating Yaci Blockfrost backend service with original blockfrost backend service");
        return blockfrostBackend;
    }
}

