/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_reader;

import io.vavr.control.Either;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.blockchain_common.domain.CardanoNetwork;
import org.cardanofoundation.lob.app.blockchain_common.domain.ChainTip;
import org.cardanofoundation.lob.app.blockchain_common.domain.FinalityScore;
import org.cardanofoundation.lob.app.blockchain_common.domain.OnChainTxDetails;
import org.zalando.problem.Problem;

public interface BlockchainReaderPublicApiIF {
    public Either<Problem, ChainTip> getChainTip();

    public Either<Problem, Optional<OnChainTxDetails>> getTxDetails(String var1);

    public Either<Problem, Map<String, Boolean>> isOnChain(Set<String> var1);

    public static class Noop
    implements BlockchainReaderPublicApiIF {
        private final CardanoNetwork network;

        @Override
        public Either<Problem, ChainTip> getChainTip() {
            return Either.right((Object)ChainTip.builder().absoluteSlot(1L).blockHash("0db89ee763a3f9fdb3f5b6e0e0d21b2da8d5768034d9090ac2d011b94bf0f9ef").epochNo(Optional.of(1)).network(this.network).isSynced(true).build());
        }

        @Override
        public Either<Problem, Optional<OnChainTxDetails>> getTxDetails(String transactionHash) {
            return Either.right(Optional.of(OnChainTxDetails.builder().transactionHash(transactionHash).blockHash("0db89ee763a3f9fdb3f5b6e0e0d21b2da8d5768034d9090ac2d011b94bf0f9ef").absoluteSlot(1L).slotConfirmations(1000000L).network(this.network).finalityScore(FinalityScore.FINAL).build()));
        }

        @Override
        public Either<Problem, Map<String, Boolean>> isOnChain(Set<String> transactionIds) {
            Map<String, Boolean> result = transactionIds.stream().collect(Collectors.toMap(transactionId -> transactionId, transactionId -> true));
            return Either.right(result);
        }

        public Noop(CardanoNetwork network) {
            this.network = network;
        }
    }
}

